/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.utils;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class Platform {
    private static boolean dev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");

    public static boolean isServer() {
        return FMLCommonHandler.instance().getEffectiveSide().isServer();
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public static boolean isSameItem(@Nonnull ItemStack itemStack1, @Nonnull ItemStack itemStack2) {
        return itemStack1.func_77969_a(itemStack2);
    }

    public static EnumFacing rotateAround(EnumFacing forward) {
        switch (forward) {
            case NORTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.NORTH;
            }
        }
        return forward;
    }

    public static String getPropertyString(Map<IProperty<?>, Comparable<?>> values, String ... extrasArgs) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<IProperty<?>, Comparable<?>> entry : values.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty<?> iproperty = entry.getKey();
            stringbuilder.append(iproperty.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(Platform.getPropertyName(iproperty, entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("inventory");
        }
        for (String args : extrasArgs) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            stringbuilder.append(args);
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> comparable) {
        return property.func_177702_a(comparable);
    }

    public static boolean isDevEnv() {
        return dev;
    }

    public static boolean disableCache() {
        return Platform.isDevEnv();
    }

    public static int hashItemStack(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        String name = stack.func_77973_b().func_77667_c(stack);
        return name.hashCode() << 8 | stack.func_77952_i();
    }
}

