/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.tileentity;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import worldcontrolteam.worldcontrol.api.card.ICard;
import worldcontrolteam.worldcontrol.api.screen.IScreenElement;
import worldcontrolteam.worldcontrol.blocks.BlockInfoPanel;
import worldcontrolteam.worldcontrol.inventory.ISlotItemFilter;
import worldcontrolteam.worldcontrol.items.ItemUpgrade;
import worldcontrolteam.worldcontrol.network.ChannelHandler;
import worldcontrolteam.worldcontrol.network.messages.PacketUpdateClientMonitorCard;
import worldcontrolteam.worldcontrol.screen.IScreenContainer;
import worldcontrolteam.worldcontrol.utils.RedstoneHelper;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class TileEntityInfoPanel
extends TileEntity
implements IItemHandler,
ITickable,
ISlotItemFilter,
IItemHandlerModifiable,
RedstoneHelper.IRedstoneConsumer {
    public int color = 10;
    public boolean power = true;
    public BlockPos origin;
    public BlockPos end;
    public IScreenElement ise;
    public EnumFacing facing;
    private NonNullList<ItemStack> itemStack = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private Map<BlockPos, Boolean> validCache = new HashMap<BlockPos, Boolean>();
    private boolean showLabels = true;

    public void init() {
        this.facing = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177228_b().get((Object)BlockInfoPanel.FACING);
        if (this.origin == null) {
            this.origin = this.func_174877_v();
        }
        if (this.end == null) {
            this.end = this.func_174877_v();
        }
        this.searchForNeighbours();
        this.updateAllProviders(false);
    }

    public void reInit() {
        this.updateAllProviders(true);
        this.searchForNeighbours();
        this.updateAllProviders(false);
    }

    private boolean isAreaValid(BlockPos o, BlockPos e) {
        for (int x = o.func_177958_n(); x <= e.func_177958_n(); ++x) {
            for (int y = o.func_177956_o(); y <= e.func_177956_o(); ++y) {
                for (int z = o.func_177952_p(); z <= e.func_177952_p(); ++z) {
                    BlockPos pos1 = new BlockPos(x, y, z);
                    if (this.validCache.containsKey(pos1)) {
                        if (this.validCache.get(pos1).booleanValue()) continue;
                        return false;
                    }
                    if (!(this.field_145850_b.func_180495_p(pos1).func_177230_c() instanceof IScreenContainer)) {
                        this.validCache.put(pos1, false);
                        return false;
                    }
                    IScreenContainer c = (IScreenContainer)this.field_145850_b.func_180495_p(pos1).func_177230_c();
                    if (c.getFacing((IBlockAccess)this.field_145850_b, pos1) != this.facing) {
                        this.validCache.put(pos1, false);
                        return false;
                    }
                    if (!c.isValid(this.field_145850_b, pos1)) {
                        this.validCache.put(pos1, false);
                        return false;
                    }
                    if (c.getOrigin((IBlockAccess)this.field_145850_b, pos1) != null && !WCUtility.compareBPos(c.getOrigin((IBlockAccess)this.field_145850_b, pos1), this.func_174877_v())) {
                        this.validCache.put(pos1, false);
                        return false;
                    }
                    if (c.isAdvanced()) {
                        this.validCache.put(pos1, false);
                        return false;
                    }
                    this.validCache.put(pos1, true);
                }
            }
        }
        return true;
    }

    public void updateAllProviders(boolean nullify) {
        for (int x = this.origin.func_177958_n(); x <= this.end.func_177958_n(); ++x) {
            for (int y = this.origin.func_177956_o(); y <= this.end.func_177956_o(); ++y) {
                for (int z = this.origin.func_177952_p(); z <= this.end.func_177952_p(); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!(this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof IScreenContainer)) continue;
                    if (nullify) {
                        ((IScreenContainer)this.field_145850_b.func_180495_p(pos).func_177230_c()).setOrigin(this.field_145850_b, pos, null);
                        continue;
                    }
                    ((IScreenContainer)this.field_145850_b.func_180495_p(pos).func_177230_c()).setOrigin(this.field_145850_b, pos, this.func_174877_v());
                }
            }
        }
    }

    private boolean inSamePlane(BlockPos c) {
        switch (this.facing) {
            case UP: 
            case DOWN: {
                return c.func_177956_o() == this.origin.func_177956_o();
            }
            case NORTH: 
            case SOUTH: {
                return c.func_177952_p() == this.origin.func_177952_p();
            }
        }
        return c.func_177958_n() == this.origin.func_177958_n();
    }

    public void tryToAdd(BlockPos aPos) {
        if (!this.inSamePlane(aPos)) {
            return;
        }
        this.updateAllProviders(true);
        this.searchForNeighbours();
        this.updateAllProviders(false);
    }

    private void searchForNeighbours() {
        this.validCache = new HashMap<BlockPos, Boolean>();
        EnumFacing left = EnumFacing.WEST;
        EnumFacing down = EnumFacing.DOWN;
        switch (this.facing) {
            case UP: 
            case DOWN: {
                left = EnumFacing.WEST;
                down = EnumFacing.NORTH;
                break;
            }
            case EAST: 
            case WEST: {
                left = EnumFacing.NORTH;
                down = EnumFacing.DOWN;
                break;
            }
            case NORTH: 
            case SOUTH: {
                left = EnumFacing.WEST;
                down = EnumFacing.DOWN;
            }
        }
        if (!this.isAreaValid(this.origin, this.end)) {
            this.origin = this.func_174877_v();
            this.end = this.func_174877_v();
        }
        int n = 0;
        do {
            this.origin = this.origin.func_177972_a(left);
        } while (this.isAreaValid(this.origin, this.end.func_177967_a(left, ++n)));
        n = 0;
        this.origin = this.origin.func_177972_a(left.func_176734_d());
        do {
            this.origin = this.origin.func_177972_a(down);
        } while (this.isAreaValid(this.origin, this.end.func_177967_a(down, ++n)));
        this.origin = this.origin.func_177972_a(down.func_176734_d());
        n = 0;
        do {
            this.end = this.end.func_177972_a(left.func_176734_d());
        } while (this.isAreaValid(this.origin.func_177967_a(left.func_176734_d(), ++n), this.end));
        this.end = this.end.func_177972_a(left);
        n = 0;
        do {
            this.end = this.end.func_177972_a(down.func_176734_d());
        } while (this.isAreaValid(this.origin.func_177967_a(down.func_176734_d(), ++n), this.end));
        this.end = this.end.func_177972_a(down);
        IBlockState bs = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), bs, bs, 0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        if (this.origin == null) {
            this.origin = this.func_174877_v();
        }
        if (this.end == null) {
            this.end = this.func_174877_v();
        }
        if (this.facing == null) {
            this.facing = EnumFacing.NORTH;
        }
        compound.func_74768_a("oX", this.origin.func_177958_n());
        compound.func_74768_a("oY", this.origin.func_177956_o());
        compound.func_74768_a("oZ", this.origin.func_177952_p());
        compound.func_74768_a("eX", this.end.func_177958_n());
        compound.func_74768_a("eY", this.end.func_177956_o());
        compound.func_74768_a("eZ", this.end.func_177952_p());
        compound.func_74768_a("facing", this.facing.func_176745_a());
        compound.func_74757_a("power", this.power);
        compound.func_74768_a("color", this.color);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.itemStack);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.origin = new BlockPos(compound.func_74762_e("oX"), compound.func_74762_e("oY"), compound.func_74762_e("oZ"));
        this.end = new BlockPos(compound.func_74762_e("eX"), compound.func_74762_e("eY"), compound.func_74762_e("eZ"));
        this.facing = EnumFacing.func_82600_a((int)compound.func_74762_e("facing"));
        this.power = compound.func_74767_n("power");
        this.color = compound.func_74762_e("color");
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.itemStack);
        this.closeInventory(null);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("oX", this.origin.func_177958_n());
        compound.func_74768_a("oY", this.origin.func_177956_o());
        compound.func_74768_a("oZ", this.origin.func_177952_p());
        compound.func_74768_a("eX", this.end.func_177958_n());
        compound.func_74768_a("eY", this.end.func_177956_o());
        compound.func_74768_a("eZ", this.end.func_177952_p());
        compound.func_74768_a("facing", this.facing.func_176745_a());
        compound.func_74757_a("power", this.power);
        compound.func_74768_a("color", this.color);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.itemStack);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 3, compound);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        compound.func_74768_a("oX", this.origin.func_177958_n());
        compound.func_74768_a("oY", this.origin.func_177956_o());
        compound.func_74768_a("oZ", this.origin.func_177952_p());
        compound.func_74768_a("eX", this.end.func_177958_n());
        compound.func_74768_a("eY", this.end.func_177956_o());
        compound.func_74768_a("eZ", this.end.func_177952_p());
        compound.func_74768_a("facing", this.facing.func_176745_a());
        compound.func_74757_a("power", this.power);
        compound.func_74768_a("color", this.color);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.itemStack);
        return compound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound compound = pkt.func_148857_g();
        this.origin = new BlockPos(compound.func_74762_e("oX"), compound.func_74762_e("oY"), compound.func_74762_e("oZ"));
        this.end = new BlockPos(compound.func_74762_e("eX"), compound.func_74762_e("eY"), compound.func_74762_e("eZ"));
        this.facing = EnumFacing.func_82600_a((int)compound.func_74762_e("facing"));
        this.power = compound.func_74767_n("power");
        this.color = compound.func_74762_e("color");
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.itemStack);
        this.closeInventory(null);
    }

    public int getSlots() {
        return this.itemStack.size();
    }

    public ItemStack getStackInSlot(int i) {
        return (ItemStack)this.itemStack.get(i);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (slot == -1) {
            return stack;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (!stackInSlot.func_190926_b()) {
            if (stackInSlot.func_190916_E() >= Math.min(stackInSlot.func_77976_d(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - stackInSlot.func_190916_E();
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    this.itemStack.set(slot, (Object)copy);
                }
                return stack;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(stackInSlot.func_190916_E());
                this.itemStack.set(slot, (Object)copy);
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.itemStack.set(slot, (Object)stack.func_77979_a(m));
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!simulate) {
            this.itemStack.set(slot, (Object)stack);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            if (stack.func_190916_E() < amount) {
                return stack.func_77946_l();
            }
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(amount);
            return copy;
        }
        int m = Math.min(stack.func_190916_E(), amount);
        ItemStack ret = this.decrStackSize(slot, m);
        this.func_70296_d();
        return ret;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != ItemStack.field_190927_a) {
            if (stack.func_190916_E() > amount) {
                stack = stack.func_77979_a(amount);
                this.func_70296_d();
            } else {
                this.itemStack.set(slot, (Object)ItemStack.field_190927_a);
            }
        }
        return stack;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void closeInventory(EntityPlayer entityPlayer) {
        if (this.getStackInSlot(0) == ItemStack.field_190927_a) {
            this.ise = null;
        } else {
            this.ise = ((ICard)this.getCard().func_77973_b()).getRenderer(this.getCard());
            this.ise.setContext(IScreenElement.EnumScreenContext.SCREEN_BASIC, this.showLabels);
        }
    }

    public void func_73660_a() {
        if (this.getCard() != ItemStack.field_190927_a && this.ise != null) {
            ICard icard = (ICard)this.getCard().func_77973_b();
            if (!this.func_145831_w().field_72995_K) {
                icard.update(this.field_145850_b, this.getCard());
                ChannelHandler.network.sendToAllAround((IMessage)new PacketUpdateClientMonitorCard(this.func_174877_v(), this.getCard()), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 50.0));
            }
            this.ise.onCardUpdate(this.field_145850_b, this.getCard());
        }
        RedstoneHelper.checkPowered(this.field_145850_b, this);
    }

    private ItemStack getCard() {
        return this.getStackInSlot(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void setCardNBT(NBTTagCompound compound) {
        if (this.getCard() != ItemStack.field_190927_a) {
            ItemStack card = this.getCard();
            card.func_77982_d(compound);
        }
    }

    @Override
    public boolean isItemValid(int slotIndex, ItemStack itemStack) {
        if (itemStack == ItemStack.field_190927_a) {
            return true;
        }
        switch (slotIndex) {
            case 0: {
                return itemStack.func_77973_b() instanceof ICard;
            }
            case 1: {
                return itemStack.func_77973_b() instanceof ItemUpgrade && itemStack.func_77960_j() == 0;
            }
        }
        return itemStack.func_77973_b() instanceof ItemUpgrade && itemStack.func_77960_j() == 1;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (!this.isItemValid(slot, stack)) {
            return;
        }
        this.itemStack.set(slot, (Object)stack);
        if (stack != ItemStack.field_190927_a && slot == 0) {
            this.ise = ((ICard)this.getCard().func_77973_b()).getRenderer(this.getCard());
            this.ise.setContext(IScreenElement.EnumScreenContext.SCREEN_BASIC, this.showLabels);
        }
    }

    public boolean shouldShowLabels() {
        return this.showLabels;
    }

    public void updateShowLabels(boolean update) {
        this.showLabels = update;
        if (this.ise != null) {
            this.ise.setContext(IScreenElement.EnumScreenContext.SCREEN_BASIC, this.showLabels);
        }
    }

    @Override
    public boolean getPowered() {
        return this.power;
    }

    @Override
    public void setPowered(boolean value) {
        this.power = value;
    }
}

