/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.screen.element;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import worldcontrolteam.worldcontrol.api.screen.IScreenElement;
import worldcontrolteam.worldcontrol.init.WCContent;
import worldcontrolteam.worldcontrol.screen.img.ScreenImageMarshaller;

public class ScreenElementImageCard
implements IScreenElement {
    private String imgURL;
    private ScreenImageMarshaller.ImageInfo lastImageInfo;
    private World theWorld;

    @Override
    public void draw(int sizeX, int sizeY, float partialTicks) {
        if (this.theWorld == null) {
            return;
        }
        this.lastImageInfo = ScreenImageMarshaller.INSTANCE.tryGetImage(this.imgURL, this.theWorld.func_72820_D());
        double sizeY_ = Math.min((double)sizeY, this.getSizeY(sizeX));
        double sizeX_ = Math.min((double)sizeX, this.getSizeX((int)sizeY_));
        sizeY_ = Math.min(sizeY_, this.getSizeY((int)sizeX_));
        if (this.lastImageInfo == null) {
            return;
        }
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder b = t.func_178180_c();
        double pX = (double)(sizeX / 2) - sizeX_ / 2.0;
        double pY = (double)(sizeY / 2) - sizeY_ / 2.0;
        GlStateManager.func_179098_w();
        GlStateManager.func_179144_i((int)this.lastImageInfo.texID);
        b.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        b.func_181662_b(pX, pY, 0.0).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        b.func_181662_b(pX, pY + sizeY_, 0.0).func_187315_a(0.0, this.lastImageInfo.v).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        b.func_181662_b(pX + sizeX_, pY + sizeY_, 0.0).func_187315_a(this.lastImageInfo.u, this.lastImageInfo.v).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        b.func_181662_b(pX + sizeX_, pY, 0.0).func_187315_a(this.lastImageInfo.u, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        t.func_78381_a();
    }

    @Override
    public double getSizeY(int sizeX) {
        return this.lastImageInfo == null ? 0.0 : (double)((float)this.lastImageInfo.height / (float)this.lastImageInfo.width * (float)sizeX);
    }

    private double getSizeX(int sizeY) {
        return this.lastImageInfo == null ? 0.0 : (double)((float)this.lastImageInfo.width / (float)this.lastImageInfo.height * (float)sizeY);
    }

    @Override
    public void onCardUpdate(World world, ItemStack newItemStack) {
        if (newItemStack.func_77973_b() != WCContent.IMAGE_CARD) {
            return;
        }
        this.theWorld = world;
        String grabbedURL = "https://i.imgur.com/bR8ndDC.png";
        if (!ScreenImageMarshaller.INSTANCE.isImageURLValid(grabbedURL)) {
            return;
        }
        this.imgURL = grabbedURL;
    }
}

