/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.crossmod.industrialcraft2.items;

import ic2.api.tile.IEnergyStorage;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import worldcontrolteam.worldcontrol.api.card.CardState;
import worldcontrolteam.worldcontrol.api.card.compat.StringWrapper;
import worldcontrolteam.worldcontrol.items.ItemBaseCard;
import worldcontrolteam.worldcontrol.utils.NBTUtils;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class IC2EnergyStorageCard
extends ItemBaseCard {
    public IC2EnergyStorageCard() {
        super("ic2_energy_storage_card");
    }

    @Override
    public CardState update(World world, ItemStack card) {
        CardState state = CardState.NO_TARGET;
        if (card.func_77942_o()) {
            BlockPos pos = NBTUtils.getBlockPos(card.func_77978_p());
            if (world.func_175625_s(pos) instanceof IEnergyStorage) {
                IEnergyStorage energySource = (IEnergyStorage)world.func_175625_s(pos);
                card.func_77978_p().func_74768_a("max_storage", energySource.getCapacity());
                card.func_77978_p().func_74768_a("capacity", energySource.getStored());
                card.func_77978_p().func_74768_a("output", energySource.getOutput());
                state = CardState.OK;
            } else {
                state = CardState.INVALID_CARD;
            }
        }
        return state;
    }

    @Override
    public List<StringWrapper> getStringData(List<StringWrapper> list, int displaySettings, ItemStack card, boolean showLabels) {
        if (card.func_77942_o()) {
            NBTTagCompound tag = card.func_77978_p();
            int energy = tag.func_74762_e("capacity");
            int maxStorage = tag.func_74762_e("max_storage");
            list.add(new StringWrapper(WCUtility.translateFormatted("eu_energy", energy)));
            list.add(new StringWrapper(WCUtility.translateFormatted("eu_free", maxStorage - energy)));
            list.add(new StringWrapper(WCUtility.translateFormatted("eu_stored", maxStorage)));
            list.add(new StringWrapper(WCUtility.translateFormatted("fill_ratio", Math.round((float)energy / (float)maxStorage * 100.0f))));
            list.add(new StringWrapper(WCUtility.translateFormatted("info_panel_output", tag.func_74762_e("output"))));
        }
        return list;
    }

    @Override
    public List<String> getGuiData() {
        return null;
    }

    @Override
    public int getCardColor() {
        return WCUtility.RED;
    }
}

