/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.crossmod.extremereactors.reactormonitor;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import worldcontrolteam.worldcontrol.api.card.CardState;
import worldcontrolteam.worldcontrol.api.card.compat.StringWrapper;
import worldcontrolteam.worldcontrol.crossmod.extremereactors.reactormonitor.TileReactorMonitor;
import worldcontrolteam.worldcontrol.items.ItemBaseCard;
import worldcontrolteam.worldcontrol.utils.NBTUtils;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class ExtremeReactorsCard
extends ItemBaseCard {
    public ExtremeReactorsCard() {
        super("er_card");
    }

    @Override
    public CardState update(World world, ItemStack card) {
        if (card.func_77942_o()) {
            BlockPos pos = NBTUtils.getBlockPos(card.func_77978_p());
            TileReactorMonitor reactorMonitor = WCUtility.getTileEntity((IBlockAccess)world, pos, TileReactorMonitor.class).orElse(null);
            if (reactorMonitor != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74757_a("Online", reactorMonitor.isReactorOnline());
                tag.func_74780_a("storedEnergy", (double)reactorMonitor.getEnergyStored());
                tag.func_74780_a("createdEnergy", (double)reactorMonitor.getEnergyGenerated());
                tag.func_74768_a("Temp", reactorMonitor.getTemp());
                tag.func_74780_a("FillPercent", (double)reactorMonitor.getEnergyOutPercent());
                tag.func_74757_a("isPassive", reactorMonitor.getReactorController().isPassivelyCooled());
                if (reactorMonitor.getReactorController().getCoolantContainer().getVaporType() != null) {
                    tag.func_74778_a("VaporType", reactorMonitor.getReactorController().getCoolantContainer().getVaporType().getLocalizedName(new FluidStack(reactorMonitor.getReactorController().getCoolantContainer().getVaporType(), 1)));
                    tag.func_74768_a("VaporAmount", reactorMonitor.getReactorController().getCoolantContainer().getVaporAmount());
                } else {
                    tag.func_74778_a("VaporType", "Empty");
                    tag.func_74768_a("VaporAmount", 0);
                }
                if (reactorMonitor.getReactorController().getCoolantContainer().getCoolantType() != null) {
                    tag.func_74778_a("CoolantType", new FluidStack(reactorMonitor.getReactorController().getCoolantContainer().getCoolantType(), 1).getLocalizedName());
                    tag.func_74768_a("CoolantAmount", reactorMonitor.getReactorController().getCoolantContainer().getCoolantAmount());
                } else {
                    tag.func_74778_a("CoolantType", "Empty");
                    tag.func_74768_a("CoolantAmount", 0);
                }
                card.func_77978_p().func_74782_a("reactorData", (NBTBase)tag);
                return CardState.OK;
            }
            return CardState.INVALID_CARD;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<StringWrapper> getStringData(List<StringWrapper> list, int displaySettings, ItemStack card, boolean showLabels) {
        if (card.func_77942_o() && card.func_77978_p().func_74764_b("reactorData")) {
            String text;
            int txtColor;
            StringWrapper line;
            NBTTagCompound tag = card.func_77978_p().func_74775_l("reactorData");
            double perOut = tag.func_74769_h("FillPercent");
            double energyStored = tag.func_74769_h("storedEnergy");
            double outputlvl = tag.func_74769_h("createdEnergy");
            double coreTemp = tag.func_74769_h("Temp");
            int ioutputlvl = (int)outputlvl;
            int ienergyStored = (int)energyStored;
            boolean passive = tag.func_74767_n("isPassive");
            if (passive) {
                line = new StringWrapper();
                line.textLeft = WCUtility.translateFormatted("exreactors.temp", coreTemp);
                list.add(line);
                line = new StringWrapper();
                line.textLeft = WCUtility.translateFormatted("exreactors.energystored", ienergyStored);
                list.add(line);
                line = new StringWrapper();
                line.textLeft = WCUtility.translateFormatted("exreactors.createdenergy", ioutputlvl);
                list.add(line);
                line = new StringWrapper();
                line.textLeft = WCUtility.translateFormatted("exreactors.percentage", perOut);
                list.add(line);
            } else {
                line = new StringWrapper();
                line.textLeft = WCUtility.translateFormatted("exreactors.temp", coreTemp);
                list.add(line);
                line = new StringWrapper();
                line.textLeft = WCUtility.translateFormatted("exreactors.steamoutput", ioutputlvl);
                list.add(line);
                line = new StringWrapper();
                line.textLeft = WCUtility.translateFormatted("exreactors.coolanttank", tag.func_74779_i("CoolantType"), tag.func_74762_e("CoolantAmount"));
                list.add(line);
                line = new StringWrapper();
                line.textLeft = WCUtility.translateFormatted("exreactors.outputtank", tag.func_74779_i("VaporType"), tag.func_74762_e("VaporAmount"));
                list.add(line);
            }
            boolean reactorPowered = tag.func_74767_n("Online");
            if (reactorPowered) {
                txtColor = 65280;
                text = WCUtility.translateFormatted("info_panel_on", new Object[0]);
            } else {
                txtColor = 0xFF0000;
                text = WCUtility.translateFormatted("info_panel_off", new Object[0]);
            }
            if (list.size() > 0) {
                StringWrapper firstLine = list.get(0);
                firstLine.textRight = text;
                firstLine.colorRight = txtColor;
            } else {
                line = new StringWrapper();
                line.textLeft = text;
                line.colorLeft = txtColor;
                list.add(line);
            }
        }
        return list;
    }

    @Override
    public List<String> getGuiData() {
        return null;
    }

    @Override
    public int getCardColor() {
        return WCUtility.RED;
    }
}

