/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.client.model.infopanel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Pair;
import worldcontrolteam.worldcontrol.blocks.BlockAdvancedInfoPanel;
import worldcontrolteam.worldcontrol.client.model.util.ModelUtil;

public class ModelAdvancedInfoPanel
implements IModel {
    private ArrayList<ResourceLocation> textures = new ArrayList();
    private static ArrayList<ResourceLocation> textures_ = new ArrayList();
    private final ResourceLocation side;
    private final ResourceLocation back;

    public Collection<ResourceLocation> getTextures() {
        return this.textures;
    }

    public ModelAdvancedInfoPanel(ResourceLocation side, ResourceLocation back) {
        this.textures.addAll(textures_);
        this.textures.add(side);
        this.textures.add(back);
        this.side = side;
        this.back = back;
    }

    public IBakedModel bake(IModelState iModelState, VertexFormat vertexFormat, Function<ResourceLocation, TextureAtlasSprite> function) {
        return new Baked(vertexFormat, this, function, this.side, this.back);
    }

    static {
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 16; ++j) {
                textures_.add(new ResourceLocation("worldcontrol:blocks/infopanel/on/" + String.valueOf(i) + "/" + String.valueOf(j)));
                textures_.add(new ResourceLocation("worldcontrol:blocks/infopanel/off/" + String.valueOf(i) + "/" + String.valueOf(j)));
            }
        }
    }

    public static class Baked
    implements IBakedModel {
        private final VertexFormat vertexFormat;
        private final ModelAdvancedInfoPanel modelAdvancedInfoPanel;
        private Map<ResourceLocation, TextureAtlasSprite> tas;
        private Map<Pair<BlockAdvancedInfoPanel.State, EnumFacing>, List<BakedQuad>> cache;

        public Baked(VertexFormat vertexFormat, ModelAdvancedInfoPanel modelAdvancedInfoPanel, Function<ResourceLocation, TextureAtlasSprite> function, ResourceLocation side, ResourceLocation back) {
            this.vertexFormat = vertexFormat;
            this.modelAdvancedInfoPanel = modelAdvancedInfoPanel;
            this.tas = new HashMap<ResourceLocation, TextureAtlasSprite>();
            for (ResourceLocation e : modelAdvancedInfoPanel.textures) {
                this.tas.put(e, function.apply(e));
            }
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState iBlockState, @Nullable EnumFacing enumFacing, long l) {
            BlockAdvancedInfoPanel.State state = new BlockAdvancedInfoPanel.State();
            if (iBlockState instanceof IExtendedBlockState) {
                BlockAdvancedInfoPanel.State state2 = (BlockAdvancedInfoPanel.State)((IExtendedBlockState)iBlockState).getValue(BlockAdvancedInfoPanel.STATE);
                state = state2 == null ? state : state2;
            }
            Pair theMagicKey = null;
            theMagicKey = iBlockState != null ? Pair.of((Object)state, (Object)iBlockState.func_177229_b((IProperty)BlockAdvancedInfoPanel.FACING)) : Pair.of((Object)state, (Object)EnumFacing.UP);
            BlockAdvancedInfoPanel.State finalState = state;
            return this.cache.computeIfAbsent((Pair<BlockAdvancedInfoPanel.State, EnumFacing>)theMagicKey, k -> {
                ArrayList<BakedQuad> bbq = new ArrayList<BakedQuad>(6);
                final Vec3d[] others = new Vec3d[4];
                this.addBackFace((EnumFacing)k.getRight(), bbq);
                BakedQuad quad = bbq.get(0);
                UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(quad.getFormat());
                final int[] i = new int[]{0};
                quad.pipe((IVertexConsumer)new VertexTransformer((IVertexConsumer)builder){

                    public void put(int element, float ... data) {
                        VertexFormatElement.EnumUsage usage = this.parent.getVertexFormat().func_177348_c(element).func_177375_c();
                        if (usage == VertexFormatElement.EnumUsage.POSITION && data.length >= 3) {
                            int n = i[0];
                            i[0] = n + 1;
                            others[n] = new Vec3d((double)data[0], (double)data[1], (double)data[2]);
                        }
                        super.put(element, data);
                    }
                });
                Vec3d one = this.getOffset(((EnumFacing)k.getRight()).func_176734_d(), false, false, finalState.depth1);
                Vec3d two = this.getOffset(((EnumFacing)k.getRight()).func_176734_d(), false, true, finalState.depth2);
                Vec3d three = this.getOffset(((EnumFacing)k.getRight()).func_176734_d(), true, true, finalState.depth3);
                Vec3d four = this.getOffset(((EnumFacing)k.getRight()).func_176734_d(), true, false, finalState.depth4);
                Vec3d normal = two.func_178788_d(one).func_72431_c(three.func_178788_d(one)).func_72432_b();
                bbq.add(ModelUtil.createQuad(this.vertexFormat, one.field_72450_a, one.field_72448_b, one.field_72449_c, two.field_72450_a, two.field_72448_b, two.field_72449_c, three.field_72450_a, three.field_72448_b, three.field_72449_c, four.field_72450_a, four.field_72448_b, four.field_72449_c, 0.0f, 0.0f, 16.0f, 16.0f, normal, this.getConnectedFace(finalState), 0));
                return bbq;
            });
        }

        public TextureAtlasSprite getConnectedFace(BlockAdvancedInfoPanel.State state) {
            int color = state.color;
            int bitfield = 0;
            bitfield += state.left ? 0 : 1;
            bitfield += state.right ? 0 : 2;
            bitfield += state.up ? 0 : 4;
            return this.tas.get(new ResourceLocation("worldcontrol:blocks/infopanel/" + (state.power ? "on" : "off") + "/" + String.valueOf(color) + "/" + String.valueOf(bitfield += state.down ? 0 : 8)));
        }

        public void addBackFace(EnumFacing facing, List<BakedQuad> bbq) {
            bbq.add(ModelUtil.makeCubeFace(this.vertexFormat, facing.func_176734_d(), 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0f, 0.0f, 16.0f, 16.0f, this.tas.get(this.modelAdvancedInfoPanel.back), 0));
        }

        public Vec3d getOffset(EnumFacing facing, boolean left, boolean right, float depth) {
            Vec3d origin;
            switch (facing) {
                case NORTH: {
                    if (left && !right) {
                        origin = new Vec3d(0.0, 1.0, 0.0);
                        break;
                    }
                    if (left) {
                        origin = new Vec3d(0.0, 0.0, 0.0);
                        break;
                    }
                    if (right) {
                        origin = new Vec3d(1.0, 0.0, 0.0);
                        break;
                    }
                    origin = new Vec3d(1.0, 1.0, 0.0);
                    break;
                }
                case EAST: {
                    if (left && !right) {
                        origin = new Vec3d(1.0, 1.0, 0.0);
                        break;
                    }
                    if (left) {
                        origin = new Vec3d(1.0, 0.0, 0.0);
                        break;
                    }
                    if (right) {
                        origin = new Vec3d(1.0, 0.0, 1.0);
                        break;
                    }
                    origin = new Vec3d(1.0, 1.0, 1.0);
                    break;
                }
                case SOUTH: {
                    if (left && !right) {
                        origin = new Vec3d(1.0, 1.0, 1.0);
                        break;
                    }
                    if (left) {
                        origin = new Vec3d(1.0, 0.0, 1.0);
                        break;
                    }
                    if (right) {
                        origin = new Vec3d(0.0, 0.0, 1.0);
                        break;
                    }
                    origin = new Vec3d(0.0, 1.0, 1.0);
                    break;
                }
                case WEST: {
                    if (left && !right) {
                        origin = new Vec3d(0.0, 1.0, 1.0);
                        break;
                    }
                    if (left) {
                        origin = new Vec3d(0.0, 0.0, 1.0);
                        break;
                    }
                    if (right) {
                        origin = new Vec3d(0.0, 0.0, 0.0);
                        break;
                    }
                    origin = new Vec3d(0.0, 1.0, 0.0);
                    break;
                }
                case UP: {
                    if (left && !right) {
                        origin = new Vec3d(1.0, 1.0, 0.0);
                        break;
                    }
                    if (left) {
                        origin = new Vec3d(1.0, 1.0, 1.0);
                        break;
                    }
                    if (right) {
                        origin = new Vec3d(0.0, 1.0, 1.0);
                        break;
                    }
                    origin = new Vec3d(0.0, 1.0, 0.0);
                    break;
                }
                case DOWN: {
                    if (left && !right) {
                        origin = new Vec3d(0.0, 0.0, 0.0);
                        break;
                    }
                    if (left) {
                        origin = new Vec3d(0.0, 0.0, 1.0);
                        break;
                    }
                    if (right) {
                        origin = new Vec3d(1.0, 0.0, 1.0);
                        break;
                    }
                    origin = new Vec3d(1.0, 0.0, 0.0);
                    break;
                }
                default: {
                    return null;
                }
            }
            Vec3d offset = new Vec3d(facing.func_176734_d().func_176730_m());
            offset = offset.func_186678_a((double)depth);
            return origin.func_178787_e(offset);
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            if (ModelUtil.BLOCK_TRANSFORMS.containsKey(type)) {
                return Pair.of((Object)this, (Object)ModelUtil.BLOCK_TRANSFORMS.get(type).getMatrix());
            }
            return ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)type);
        }
    }
}

