/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import worldcontrolteam.worldcontrol.WorldControl;
import worldcontrolteam.worldcontrol.init.IItemBlockFactory;
import worldcontrolteam.worldcontrol.init.IModelRegistrar;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public abstract class BlockBasicTileProvider
extends Block
implements ITileEntityProvider,
IModelRegistrar,
IItemBlockFactory {
    public BlockBasicTileProvider(Material blockMaterial, String name) {
        super(blockMaterial);
        this.setBlockName(name);
    }

    @Override
    public ItemBlock createItemBlock() {
        return (ItemBlock)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.createTile(world, meta);
    }

    public abstract TileEntity createTile(World var1, int var2);

    public abstract boolean hasGUI();

    public abstract int guiID();

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.hasGUI()) {
            if (!WCUtility.getTileEntity((IBlockAccess)world, pos).isPresent() || player.func_70093_af()) {
                return false;
            }
            player.openGui((Object)WorldControl.INSTANCE, this.guiID(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    protected void setBlockName(String name) {
        this.func_149663_c("worldcontrol." + name);
        this.setRegistryName(name);
    }

    protected void defaultCreativeTab() {
        this.func_149647_a(WorldControl.TAB);
    }
}

