/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import worldcontrolteam.worldcontrol.blocks.BlockBasicTileProvider;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public abstract class BlockBasicRotate
extends BlockBasicTileProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockBasicRotate(Material material, String name) {
        super(material, name);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)entity)), 2);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropItems(world, pos);
        super.func_180663_b(world, pos, state);
    }

    private void dropItems(World world, BlockPos pos) {
        Random rand = new Random();
        WCUtility.getTileEntity((IBlockAccess)world, pos).filter(te -> te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).ifPresent(tileEntity -> {
            IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack item = handler.getStackInSlot(i);
                if (item == ItemStack.field_190927_a || item.func_190916_E() <= 0) continue;
                float rx = rand.nextFloat() * 0.8f + 0.1f;
                float ry = rand.nextFloat() * 0.8f + 0.1f;
                float rz = rand.nextFloat() * 0.8f + 0.1f;
                EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), item.func_77946_l());
                float factor = 0.05f;
                entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
                entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
                entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
                world.func_72838_d((Entity)entityItem);
                item.func_190920_e(0);
            }
            EntityItem e = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((Block)this));
            world.func_72838_d((Entity)e);
        });
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }
}

