/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.integration.imc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.Chisel;
import team.chisel.api.IMC;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.common.carving.Carving;

public class IMCHandler {
    public static final IMCHandler INSTANCE = new IMCHandler();
    public final TObjectIntMap<String> imcCounts = new TObjectIntHashMap();
    private int order = 1000;
    private SetMultimap<String, String> deprecatedUses = HashMultimap.create();

    private IMCHandler() {
    }

    public void handleMessage(FMLInterModComms.IMCMessage message) {
        for (IMC imc : IMC.values()) {
            if (!imc.key.equals(message.key)) continue;
            this.handle(message, imc);
        }
    }

    private Pair<ItemStack, IBlockState> parseNBT(NBTTagCompound tag) {
        NBTTagCompound stacktag = tag.func_74775_l("stack");
        String blockname = tag.func_74779_i("block");
        int blockmeta = tag.func_74762_e("meta");
        Preconditions.checkArgument((!stacktag.func_82582_d() || !blockname.isEmpty() ? 1 : 0) != 0, (Object)"Must provide stack or blockstate.");
        ItemStack stack = null;
        if (!stacktag.func_82582_d()) {
            stack = new ItemStack(stacktag);
        }
        IBlockState state = null;
        if (!blockname.isEmpty()) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
            Preconditions.checkNotNull((Object)block, (String)"Could not find block %s in registry!", (Object)blockname);
            state = block.func_176203_a(blockmeta);
        }
        return Pair.of((Object)stack, state);
    }

    private void handle(FMLInterModComms.IMCMessage message, IMC type) {
        Set usedForMod;
        this.imcCounts.adjustOrPutValue((Object)message.getSender(), 1, 1);
        if (type.isDeprecated() && (usedForMod = this.deprecatedUses.get((Object)message.getSender())).add(type.toString())) {
            Chisel.logger.warn("Mod {} is using deprecated IMC {}! This IMC type may be removed soon, please notify the author of this mod.", (Object)message.getSender(), (Object)type);
        }
        ICarvingRegistry reg = Carving.chisel;
        String[] data = null;
        ResourceLocation resource = null;
        if (message.isStringMessage()) {
            data = message.getStringValue().split("\\|");
            resource = new ResourceLocation(data[1]);
        }
        try {
            switch (type) {
                case ADD_VARIATION: 
                case REMOVE_VARIATION: {
                    Block block = (Block)Block.field_149771_c.func_82594_a(resource);
                    short meta = Short.parseShort(data[2]);
                    if (type == IMC.ADD_VARIATION) {
                        reg.addVariation(data[0], block.func_176203_a((int)meta), this.order++);
                        break;
                    }
                    reg.removeVariation(block.func_176203_a((int)meta), data[0]);
                    break;
                }
                case REGISTER_GROUP_ORE: {
                    reg.registerOre(data[0], data[1]);
                    break;
                }
                case ADD_VARIATION_V2: {
                    NBTTagCompound tag = message.getNBTValue();
                    String group = tag.func_74779_i("group");
                    Preconditions.checkNotNull((Object)Strings.emptyToNull((String)group), (Object)"No group specified");
                    Pair<ItemStack, IBlockState> variationdata = this.parseNBT(tag);
                    ICarvingVariation v = variationdata.getLeft() == null ? CarvingUtils.variationFor((IBlockState)variationdata.getRight(), this.order++) : (variationdata.getRight() == null ? CarvingUtils.variationFor((ItemStack)variationdata.getLeft(), this.order++) : CarvingUtils.variationFor((ItemStack)variationdata.getLeft(), (IBlockState)variationdata.getRight(), this.order++));
                    reg.addVariation(group, v);
                    break;
                }
                case REMOVE_VARIATION_V2: {
                    NBTTagCompound tag = message.getNBTValue();
                    String group = tag.func_74779_i("group");
                    Pair<ItemStack, IBlockState> variationdata = this.parseNBT(tag);
                    if (Strings.isNullOrEmpty((String)group)) {
                        if (variationdata.getLeft() != null) {
                            reg.removeVariation((ItemStack)variationdata.getLeft());
                        }
                        if (variationdata.getRight() != null) {
                            reg.removeVariation((IBlockState)variationdata.getRight());
                        }
                    } else {
                        if (variationdata.getLeft() != null) {
                            reg.removeVariation((ItemStack)variationdata.getLeft(), group);
                        }
                        if (variationdata.getRight() != null) {
                            reg.removeVariation((IBlockState)variationdata.getRight(), group);
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid IMC constant! How...what...?");
                }
            }
        }
        catch (Exception e) {
            NBTTagCompound value = message.isNBTMessage() ? message.getNBTValue() : (message.isStringMessage() ? message.getStringValue() : "UNKNOWN");
            Chisel.logger.error("Could not handle data {} for IMC type {}. This was sent from mod {}.\n!! This is a bug in that mod !!\nSwallowing error and continuing...", (Object)value, (Object)type.name(), (Object)message.getSender());
            e.printStackTrace();
        }
    }
}

