/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.api.block;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.registries.IForgeRegistry;
import team.chisel.api.block.BlockCreator;
import team.chisel.api.block.BlockProvider;
import team.chisel.api.block.ChiselBlockBuilder;
import team.chisel.api.block.VariationData;
import team.chisel.common.block.ItemChiselBlock;

@ParametersAreNonnullByDefault
public class ChiselBlockFactory {
    private final IForgeRegistry<Block> registry;
    private final String domain;

    public static ChiselBlockFactory newFactory(IForgeRegistry<Block> registry, String domain) {
        return new ChiselBlockFactory(registry, domain);
    }

    public <T extends Block> ChiselBlockBuilder<T> newBlock(Material material, String blockName, BlockCreator<T> creator, Class<T> blockClass) {
        return this.newBlock(material, blockName, creator, blockClass, ItemBlock.class);
    }

    public <T extends Block> ChiselBlockBuilder<T> newBlock(Material material, String blockName, final BlockCreator<T> creator, final Class<T> blockClass, Class<? extends ItemBlock> itemBlockClass) {
        return this.newBlock(material, blockName, new BlockProvider<T>(){

            @Override
            public T createBlock(Material material, int index, int totalBlocks, VariationData ... data) {
                return creator.createBlock(material, index, totalBlocks, data);
            }

            @Override
            public Class<T> getBlockClass() {
                return blockClass;
            }

            @Override
            public ItemBlock createItemBlock(T block) {
                return (ItemBlock)new ItemChiselBlock((Block)block).setRegistryName(block.getRegistryName());
            }
        });
    }

    public <T extends Block> ChiselBlockBuilder<T> newBlock(Material material, String blockName, BlockProvider<T> provider) {
        return this.newBlock(material, blockName, blockName, provider);
    }

    public <T extends Block> ChiselBlockBuilder<T> newBlock(Material material, String blockName, @Nullable String group, BlockProvider<T> provider) {
        return new ChiselBlockBuilder<T>(this.registry, material, this.domain, blockName, group, provider);
    }

    private ChiselBlockFactory(IForgeRegistry<Block> registry, String domain) {
        this.registry = registry;
        this.domain = domain;
    }

    public IForgeRegistry<Block> getRegistry() {
        return this.registry;
    }
}

