/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.advancement.Triggers;
import com.mrcrayfish.furniture.blocks.BlockFurnitureTile;
import com.mrcrayfish.furniture.entity.EntitySeat;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.tileentity.TileEntityColoured;
import com.mrcrayfish.furniture.util.Bounds;
import com.mrcrayfish.furniture.util.SeatUtil;
import com.mrcrayfish.furniture.util.StateHelper;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockModernCouch
extends BlockFurnitureTile {
    public static final PropertyInteger COLOUR = PropertyInteger.func_177719_a((String)"colour", (int)0, (int)15);
    public static final PropertyEnum<CouchType> TYPE = PropertyEnum.func_177709_a((String)"type", CouchType.class);
    private static final AxisAlignedBB[] COUCH_BASE = new Bounds(1, 3, 0, 15, 9, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COUCH_ARMREST_LEFT = new Bounds(1, 0, 0, 15, 13, 2).getRotatedBounds();
    private static final AxisAlignedBB[] COUCH_ARMREST_RIGHT = new Bounds(1, 0, 14, 15, 13, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COUCH_BACKREST = new Bounds(11, 9, 0, 15, 19, 16).getRotatedBounds();

    public BlockModernCouch() {
        super(Material.field_151580_n);
        this.func_149663_c("modern_couch");
        this.setRegistryName("modern_couch");
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)CouchType.BOTH)).func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(0)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityColoured) {
            int colour = ((TileEntityColoured)tileEntity).getColour();
            state = state.func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(colour));
        }
        boolean left = false;
        boolean right = false;
        if (StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.LEFT) == this && StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.LEFT) == StateHelper.Direction.DOWN) {
            left = true;
        }
        if (StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.RIGHT) == this && StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.RIGHT) == StateHelper.Direction.DOWN) {
            right = true;
        }
        if (left && !right) {
            return state.func_177226_a(TYPE, (Comparable)((Object)CouchType.LEFT));
        }
        if (!left && right) {
            return state.func_177226_a(TYPE, (Comparable)((Object)CouchType.RIGHT));
        }
        if (!left && !right) {
            return state.func_177226_a(TYPE, (Comparable)((Object)CouchType.BOTH));
        }
        return state.func_177226_a(TYPE, (Comparable)((Object)CouchType.NONE));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        return state.func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(meta));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == Items.field_151057_cb && heldItem.func_82837_s() && heldItem.func_82833_r().equals("jeb_")) {
            worldIn.func_175656_a(pos, FurnitureBlocks.COUCH_JEB.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
            if (!playerIn.func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
            Triggers.trigger(Triggers.CREATE_COUCH_JEB, playerIn);
            return true;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityColoured) {
            TileEntityColoured tileEntityColoured = (TileEntityColoured)tileEntity;
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemDye) {
                if (tileEntityColoured.getColour() != 15 - heldItem.func_77952_i()) {
                    tileEntityColoured.setColour(heldItem.func_77952_i());
                    if (!playerIn.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                    TileEntityUtil.markBlockForUpdate(worldIn, pos);
                }
                return true;
            }
        }
        return SeatUtil.sitOnBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, 0.3125);
    }

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state, World world, BlockPos pos) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        list.add(COUCH_BACKREST[facing.func_176736_b()]);
        list.add(COUCH_BASE[facing.func_176736_b()]);
        if (state.func_177229_b(TYPE) == CouchType.LEFT || state.func_177229_b(TYPE) == CouchType.BOTH) {
            list.add(COUCH_ARMREST_LEFT[facing.func_176736_b()]);
        }
        if (state.func_177229_b(TYPE) == CouchType.RIGHT || state.func_177229_b(TYPE) == CouchType.BOTH) {
            list.add(COUCH_ARMREST_RIGHT[facing.func_176736_b()]);
        }
        return list;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean p_185477_7_) {
        if (!(entity instanceof EntitySeat)) {
            List<AxisAlignedBB> boxes = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos), worldIn, pos);
            for (AxisAlignedBB box : boxes) {
                BlockModernCouch.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
            }
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)world, pos), world, pos)) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityColoured();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, COLOUR, TYPE});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityColoured) {
            ((TileEntityColoured)tileEntity).setColour(15 - stack.func_77960_j());
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tileEntity, ItemStack stack) {
        if (tileEntity instanceof TileEntityColoured) {
            TileEntityColoured couch = (TileEntityColoured)tileEntity;
            ItemStack itemstack = new ItemStack((Block)this, 1, couch.getColour());
            BlockModernCouch.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
        } else {
            super.func_180657_a(worldIn, player, pos, state, tileEntity, stack);
        }
    }

    public void func_149666_a(CreativeTabs item, NonNullList<ItemStack> items) {
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int metadata = 0;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityColoured) {
            metadata = ((TileEntityColoured)tileEntity).getColour();
        }
        return new ItemStack((Block)this, 1, metadata);
    }

    public static enum CouchType implements IStringSerializable
    {
        NONE,
        LEFT,
        RIGHT,
        BOTH;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }
    }
}

