/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.asm.Lighting;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.blocks.BlockSpotlight;
import com.rwtema.extrautils2.lighting.ILight;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.utils.helpers.LightMathHelper;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TileSpotlight
extends TilePower
implements ILight {
    public static final int range = 78;
    public static final int range_side = 32;
    public static final int range_back = 1;
    public static final float POWER = 4.0f;
    public static HashMap<EnumFacing, float[]> baseNormals;
    public float[] normal;

    private static void initNormals() {
        baseNormals = new HashMap();
        baseNormals.put(EnumFacing.DOWN, new float[]{0.0f, -1.0f, 0.0f});
        baseNormals.put(EnumFacing.UP, new float[]{0.0f, 1.0f, 0.0f});
        float sqr2 = (float)Math.sqrt(0.5);
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            float[] normal = new float[]{(float)facing.func_82601_c() * sqr2, -sqr2, (float)facing.func_82599_e() * sqr2};
            baseNormals.put(facing, normal);
        }
    }

    @Override
    public float getPower() {
        return 4.0f;
    }

    @Override
    public World getLightWorld() {
        return this.field_145850_b;
    }

    @Override
    public float getLightOffset(BlockPos p, EnumSkyBlock type) {
        float foreDist;
        if (!this.active) {
            return 0.0f;
        }
        if (this.normal == null) {
            Chunk chunk = this.field_145850_b.func_175726_f(this.field_174879_c);
            if (chunk == null) {
                return 0.0f;
            }
            this.normal = this.getBaseNormal(chunk.func_177435_g(this.field_174879_c));
        }
        if ((foreDist = 1.0f + this.normal[0] * (float)(p.func_177958_n() - this.field_174879_c.func_177958_n()) + this.normal[1] * (float)(p.func_177956_o() - this.field_174879_c.func_177956_o()) + this.normal[2] * (float)(p.func_177952_p() - this.field_174879_c.func_177952_p())) <= 0.0f) {
            return 0.0f;
        }
        float sideDist = this.dist((float)(p.func_177958_n() - this.field_174879_c.func_177958_n()) - foreDist * this.normal[0], (float)(p.func_177956_o() - this.field_174879_c.func_177956_o()) - foreDist * this.normal[1], (float)(p.func_177952_p() - this.field_174879_c.func_177952_p()) - foreDist * this.normal[2]);
        float mH = 1.0f - LightMathHelper.approxSqrt(foreDist * foreDist + sideDist * sideDist, 6084.0f);
        if (mH < 0.0f) {
            return 0.0f;
        }
        if ((mH *= 1.0f - sideDist / (0.5f + foreDist) / 2.0f) < 0.0f) {
            return 0.0f;
        }
        return Math.min(mH * 16.0f, 16.0f);
    }

    private float dist(float a, float b, float c) {
        return MathHelper.func_76129_c((float)(a * a + b * b + c * c));
    }

    public float sqr(float a) {
        return a * a;
    }

    @Override
    public EnumSkyBlock[] getLightType() {
        return new EnumSkyBlock[]{EnumSkyBlock.BLOCK};
    }

    @Override
    public void onPowerChanged() {
        this.markForUpdate();
    }

    @Override
    public void addToDescriptionPacket(XUPacketBuffer packet) {
        packet.writeBoolean(this.active);
        if (this.normal != null) {
            packet.writeBoolean(true);
            for (float v : this.normal) {
                packet.writeFloat(v);
            }
        } else {
            packet.writeBoolean(false);
        }
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        float[] prevNormal;
        boolean b = packet.readBoolean();
        float[] fArray = prevNormal = this.normal != null ? (float[])this.normal.clone() : null;
        if (packet.readBoolean()) {
            this.normal = new float[3];
            for (int i = 0; i < this.normal.length; ++i) {
                this.normal[i] = packet.readFloat();
            }
        } else {
            this.normal = null;
        }
        if (b != this.active || !Arrays.equals(prevNormal, this.normal)) {
            BlockSpotlight.worldModelCache.remove(this);
            BlockSpotlight.renderModelCache.remove(this);
            this.active = b;
            this.updateLight();
        }
    }

    private void updateLight() {
        this.field_145850_b.func_147458_c(this.field_174879_c.func_177958_n() - 78, this.field_174879_c.func_177956_o() - 78, this.field_174879_c.func_177952_p() - 78, this.field_174879_c.func_177958_n() + 78, this.field_174879_c.func_177956_o() + 78, this.field_174879_c.func_177952_p() + 78);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeNormal(compound);
        return compound;
    }

    protected void writeNormal(NBTTagCompound compound) {
        if (this.normal != null) {
            NBTTagCompound normal = NBTHelper.getOrInitTagCompound(compound, "Normal");
            normal.func_74776_a("NormalX", this.normal[0]);
            normal.func_74776_a("NormalY", this.normal[1]);
            normal.func_74776_a("NormalZ", this.normal[2]);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readNormal(compound);
    }

    protected void readNormal(NBTTagCompound compound) {
        if (compound.func_150297_b("Normal", 10)) {
            this.normal = new float[3];
            NBTTagCompound normalTag = compound.func_74775_l("Normal");
            this.normal[0] = normalTag.func_74760_g("NormalX");
            this.normal[1] = normalTag.func_74760_g("NormalY");
            this.normal[2] = normalTag.func_74760_g("NormalZ");
        } else {
            this.normal = null;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        Lighting.unregister(this, this.getLightMap());
        if (this.field_145850_b.field_72995_K) {
            this.updateLight();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        Lighting.unregister(this, this.getLightMap());
        if (this.field_145850_b.field_72995_K) {
            this.updateLight();
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Lighting.register(this, this.getLightMap());
    }

    protected WeakHashMap<World, HashMap<EnumSkyBlock, Set<ILight>>> getLightMap() {
        return Lighting.plusLights;
    }

    public float[] getBaseNormal(IBlockState state) {
        if (this.normal == null) {
            if (state == null) {
                return (float[])baseNormals.get(EnumFacing.DOWN).clone();
            }
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL);
            this.normal = (float[])baseNormals.get(facing).clone();
        }
        return this.normal;
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack, xuBlock);
        this.normal = null;
        this.updateNormal(state, placer);
    }

    public void updateNormal(IBlockState state, EntityLivingBase placer) {
        double v;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL);
        Vec3d lookVec = placer.func_70040_Z();
        lookVec = lookVec.func_72432_b();
        if (this.normal != null && (v = lookVec.func_72430_b(new Vec3d((double)this.normal[0], (double)this.normal[1], (double)this.normal[2]))) > 0.995) {
            lookVec = new Vec3d(-lookVec.field_72450_a, -lookVec.field_72448_b, -lookVec.field_72449_c);
        }
        this.normal = (v = lookVec.func_72430_b(new Vec3d(facing.func_176730_m()))) < 0.75 ? new float[]{(float)lookVec.field_72450_a, (float)lookVec.field_72448_b, (float)lookVec.field_72449_c} : baseNormals.get(facing);
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (this.isValidPlayer(playerIn)) {
            return false;
        }
        this.updateNormal(state, (EntityLivingBase)playerIn);
        this.markForUpdate();
        return true;
    }

    public boolean canRenderBreaking() {
        return true;
    }

    static {
        TileSpotlight.initNormals();
    }
}

