/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.textures;

import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.textures.SpriteLoaderProcessing;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import java.awt.image.BufferedImage;
import net.minecraft.util.ResourceLocation;

public class SpriteColorMask
extends SpriteLoaderProcessing {
    final boolean isMask;

    public SpriteColorMask(String tex, String mask, boolean isMask) {
        super(SpriteColorMask.getSpriteName(tex, mask), new ResourceLocation(tex));
        this.isMask = isMask;
    }

    public static String registerSupplier(String tex, String mask, boolean isMask) {
        String spriteName = SpriteColorMask.getSpriteName(tex, mask);
        Textures.registerSupplier(spriteName, () -> new SpriteColorMask(tex, mask, isMask));
        return spriteName;
    }

    public static String getSpriteName(String tex, String mask) {
        return "extrautils2:" + tex.replace(':', '_') + "_" + mask;
    }

    @Override
    protected void process(BufferedImage image, int i, int n, int w) {
        float min = 1.0f;
        float max = 0.0f;
        for (int px = 0; px < w; ++px) {
            for (int py = 0; py < w; ++py) {
                int col = image.getRGB(px, py);
                float intensity = (float)ColorHelper.brightness(col) / 255.0f;
                min = Math.min(min, intensity);
                max = Math.max(max, intensity);
            }
        }
        float k0 = min;
        float k1 = 1.0f - min;
        for (int px = 0; px < w; ++px) {
            for (int py = 0; py < w; ++py) {
                float alpha;
                int col = image.getRGB(px, py);
                float intensity = (float)ColorHelper.brightness(col) / 255.0f;
                float v = (intensity - min) / (max - min);
                v = k0 + k1 * v;
                if (this.isMask) {
                    alpha = Math.min(v * (1.0f - v) * 2.0f, 1.0f);
                    alpha = alpha * 0.5f + 0.5f;
                } else {
                    alpha = 1.0f;
                }
                image.setRGB(px, py, ColorHelper.colorClamp(v, v, v, alpha));
            }
        }
    }
}

