/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.textures;

import com.rwtema.extrautils2.utils.datastructures.IntArrKey;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class ConnectedTexturesHelper {
    public static int[] textureFromArrangement;
    public static boolean[] isAdvancedArrangement;
    public static int[] textureIds;
    static int[] sideA;
    static int[] sideB;
    static int[] corner;
    static int[][] cornerTex;
    static int[] trueTextures;
    static int[][][] texBounds;

    public static void init() {
        sideA = new int[]{1, 4, 4, 1};
        sideB = new int[]{2, 2, 8, 8};
        corner = new int[]{16, 32, 64, 128};
        cornerTex = new int[47][4];
        texBounds = new int[47][][];
        textureFromArrangement = new int[256];
        isAdvancedArrangement = new boolean[16];
        textureIds = new int[47];
        int j = 0;
        boolean[] validTexture = new boolean[625];
        int[] revTextureIds = new int[625];
        int[] k = new int[]{1, 5, 25, 125};
        HashMap<IntArrKey, Integer> texToArrangement = new HashMap<IntArrKey, Integer>();
        for (int ar = 0; ar < 256; ++ar) {
            int texId = 0;
            int[] t = new int[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                int tex;
                boolean sA = (ar & sideA[i2]) != 0;
                boolean sB = (ar & sideB[i2]) != 0;
                boolean c = (ar & corner[i2]) != 0;
                t[i2] = tex = ConnectedTexturesHelper.getTex(sA, sB, c);
                texId += tex * k[i2];
                if (sA || sB) continue;
                ConnectedTexturesHelper.isAdvancedArrangement[ar & 0xF] = true;
            }
            if (!validTexture[texId]) {
                texToArrangement.put(new IntArrKey(t), ar);
                ConnectedTexturesHelper.textureIds[j] = texId;
                ConnectedTexturesHelper.cornerTex[j] = t;
                revTextureIds[texId] = j++;
                validTexture[texId] = true;
            }
            ConnectedTexturesHelper.textureFromArrangement[ar] = revTextureIds[texId];
        }
        HashSet<Object> definites = new HashSet<Object>();
        int i3 = 0;
        while (i3 < 5) {
            definites.add(texToArrangement.get(new IntArrKey(i3, i3, i3, i3++)));
        }
        definites.add(texToArrangement.get(new IntArrKey(3, 4, 3, 4)));
        definites.add(texToArrangement.get(new IntArrKey(4, 3, 4, 3)));
        definites.add(ConnectedTexturesHelper.makeArrangementFull(false, true, true, true));
        definites.add(ConnectedTexturesHelper.makeArrangementFull(true, false, true, true));
        definites.add(ConnectedTexturesHelper.makeArrangementFull(true, true, false, true));
        definites.add(ConnectedTexturesHelper.makeArrangementFull(true, true, true, false));
        definites.add(ConnectedTexturesHelper.makeArrangementEmpty(true, false, false, false));
        definites.add(ConnectedTexturesHelper.makeArrangementEmpty(false, true, false, false));
        definites.add(ConnectedTexturesHelper.makeArrangementEmpty(false, false, true, false));
        definites.add(ConnectedTexturesHelper.makeArrangementEmpty(false, false, false, true));
        definites.add(ConnectedTexturesHelper.makeArrangementFull(false, true, false, true));
        definites.add(ConnectedTexturesHelper.makeArrangementFull(false, true, true, false));
        definites.add(ConnectedTexturesHelper.makeArrangementFull(true, false, false, true));
        definites.add(ConnectedTexturesHelper.makeArrangementFull(true, false, true, false));
        definites.add(ConnectedTexturesHelper.makeArrangementEmpty(false, true, false, true));
        definites.add(ConnectedTexturesHelper.makeArrangementEmpty(false, true, true, false));
        definites.add(ConnectedTexturesHelper.makeArrangementEmpty(true, false, false, true));
        definites.add(ConnectedTexturesHelper.makeArrangementEmpty(true, false, true, false));
        List list = definites.stream().map(i -> textureFromArrangement[i]).collect(Collectors.toList());
        trueTextures = new int[list.size()];
        for (int i4 = 0; i4 < list.size(); ++i4) {
            ConnectedTexturesHelper.trueTextures[i4] = (Integer)list.get(i4);
        }
        TIntIntHashMap horizUp = new TIntIntHashMap(16, 0.5f, -1, -1);
        TIntIntHashMap horizDown = new TIntIntHashMap(16, 0.5f, -1, -1);
        int ul = 0;
        int dl = 1;
        int dr = 2;
        int ur = 3;
        for (int trueTexture : trueTextures) {
            int[] tex = cornerTex[trueTexture];
            horizUp.putIfAbsent(tex[ul] * 8 + tex[ur], trueTexture);
            horizDown.putIfAbsent(tex[dl] * 8 + tex[dr], trueTexture);
        }
        for (int i5 = 0; i5 < 47; ++i5) {
            if (list.contains(i5)) {
                ConnectedTexturesHelper.texBounds[i5] = new int[][]{{i5, 0, 0, 16, 16}};
                continue;
            }
            int[] tex = cornerTex[i5];
            int hu = horizUp.get(tex[ul] * 8 + tex[ur]);
            int hd = horizDown.get(tex[dl] * 8 + tex[dr]);
            if (hu >= 0 && hd >= 0) {
                ConnectedTexturesHelper.texBounds[i5] = new int[][]{{hu, 0, 0, 16, 8}, {hd, 0, 8, 16, 16}};
                continue;
            }
            throw new IllegalStateException();
        }
    }

    private static int makeArrangementEmpty(boolean l, boolean r, boolean u, boolean d) {
        return ConnectedTexturesHelper.makeArrangement(l, r, u, d, false, false, false, false);
    }

    private static int makeArrangementFull(boolean l, boolean r, boolean u, boolean d) {
        return ConnectedTexturesHelper.makeArrangement(l, r, u, d, true, true, true, true);
    }

    private static int makeArrangement(boolean l, boolean r, boolean u, boolean d, boolean ul, boolean ur, boolean dl, boolean dr) {
        int t = 0;
        if (l) {
            t |= 1;
        }
        if (u) {
            t |= 2;
        }
        if (r) {
            t |= 4;
        }
        if (d) {
            t |= 8;
        }
        if (ul) {
            t |= 0x10;
        }
        if (ur) {
            t |= 0x20;
        }
        if (dr) {
            t |= 0x40;
        }
        if (dl) {
            t |= 0x80;
        }
        return t;
    }

    private static int getTex(boolean sideA, boolean sideB, boolean corner) {
        return sideA ? (sideB ? 0 : 1) : (sideB ? 2 : (corner ? 3 : 4));
    }
}

