/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.quarry;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.dimensions.workhousedim.WorldProviderSpecialDim;
import com.rwtema.extrautils2.eventhandlers.ItemCaptureHandler;
import com.rwtema.extrautils2.eventhandlers.XPCaptureHandler;
import com.rwtema.extrautils2.fakeplayer.XUFakePlayer;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetEnergyStorage;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.gui.backend.WidgetTextData;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.itemhandler.SingleStackHandler;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerFilter;
import com.rwtema.extrautils2.itemhandler.StackDump;
import com.rwtema.extrautils2.items.ItemBiomeMarker;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.power.energy.XUEnergyStorage;
import com.rwtema.extrautils2.quarry.TileQuarryProxy;
import com.rwtema.extrautils2.tile.RedstoneState;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.ListRandomOffset;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class TileQuarry
extends TilePower
implements ITickable,
IDynamicHandler {
    static final ArrayList<BlockPos> offset = new ArrayList();
    static final HashMap<BlockPos, ArrayList<EnumFacing>> offset_sides = new HashMap();
    private static final ItemStack genericDigger = new ItemStack(Items.field_151046_w, 1);
    public static int ENERGY_PER_OPERATION = 16000;
    private final StackDump extraStacks = this.registerNBT("extrastacks", new StackDump());
    public boolean redstoneDirty = true;
    public boolean redstoneActive;
    protected SingleStackHandlerFilter.ItemFilter filter = this.registerNBT("filter", new SingleStackHandlerFilter.ItemFilter(){

        @Override
        protected void onContentsChanged() {
            TileQuarry.this.func_70296_d();
        }
    });
    Biome lastBiome = null;
    XUEnergyStorage energy = this.registerNBT("energy", new XUEnergyStorage(ENERGY_PER_OPERATION * 10));
    ChunkPos posKey = null;
    ChunkPos chunkPos = null;
    NBTSerializable.Int curBlockLocation = this.registerNBT("location", new NBTSerializable.Int(0));
    long last_tick_time = -1L;
    int num_ticks = 0;
    NBTSerializable.Long blocksMined = this.registerNBT("mined", new NBTSerializable.Long());
    BlockPos.MutableBlockPos digPos = new BlockPos.MutableBlockPos();
    boolean needsToCheckNearbyBlocks = true;
    boolean hasNearbyBlocks = false;
    private ItemBiomeMarker.ItemBiomeHandler biomeHandler = this.registerNBT("biome_marker", new ItemBiomeMarker.ItemBiomeHandler(){

        @Override
        protected void onContentsChanged() {
            Biome biome = this.getBiome();
            if (biome != null && TileQuarry.this.lastBiome != null && biome != TileQuarry.this.lastBiome && TileQuarry.this.chunkPos != null && TileQuarry.this.posKey != null) {
                TileQuarry.this.lastBiome = biome;
                TileQuarry.this.getNewChunk();
            }
            TileQuarry.this.func_70296_d();
        }
    });
    private NBTSerializable.NBTEnum<RedstoneState> redstone_state = this.registerNBT("redstone_state", new NBTSerializable.NBTEnum<RedstoneState>(RedstoneState.OPERATE_ALWAYS));
    private ItemStack diggerTool;
    private final SingleStackHandler enchants = this.registerNBT("enchants", new SingleStackHandler(){

        @Override
        protected int getStackLimit(@Nonnull ItemStack stack) {
            if (stack.func_77973_b() != Items.field_151134_bR) {
                return 0;
            }
            Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
            if (map.isEmpty()) {
                return 0;
            }
            for (Enchantment enchantment : map.keySet()) {
                if (!enchantment.func_92089_a(genericDigger)) continue;
                return 1;
            }
            return 0;
        }

        @Override
        protected void onContentsChanged() {
            TileQuarry.this.func_70296_d();
            TileQuarry.this.diggerTool = null;
        }
    });
    private XUFakePlayer fakePlayer;

    public TileQuarry() {
        this.registerNBT("pos_key_2", new INBTSerializable<NBTTagCompound>(){

            public NBTTagCompound serializeNBT() {
                NBTTagCompound tags = new NBTTagCompound();
                if (TileQuarry.this.posKey != null && TileQuarry.this.chunkPos != null) {
                    tags.func_74768_a("x", TileQuarry.this.posKey.field_77276_a);
                    tags.func_74768_a("z", TileQuarry.this.posKey.field_77275_b);
                }
                return tags;
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                if (nbt.func_82582_d()) {
                    TileQuarry.this.posKey = null;
                    TileQuarry.this.chunkPos = null;
                } else {
                    TileQuarry.this.posKey = new ChunkPos(nbt.func_74762_e("x"), nbt.func_74762_e("z"));
                    TileQuarry.this.chunkPos = WorldProviderSpecialDim.adjustChunkRef(TileQuarry.this.posKey);
                }
            }
        });
    }

    @Override
    protected Iterable<ItemStack> getDropHandler() {
        return Iterables.concat(InventoryHelper.getItemHandlerIterator((IItemHandler)this.filter), InventoryHelper.getItemHandlerIterator((IItemHandler)this.enchants), InventoryHelper.getItemHandlerIterator((IItemHandler)this.biomeHandler));
    }

    @Override
    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        super.breakBlock(worldIn, pos, state);
        if (this.posKey != null) {
            WorldProviderSpecialDim.releaseChunk(this.posKey);
        }
    }

    @Override
    public float getPower() {
        return Float.NaN;
    }

    @Override
    public void onPowerChanged() {
    }

    public boolean hasNearbyBlocks() {
        if (this.needsToCheckNearbyBlocks || this.field_145850_b.field_72995_K) {
            this.needsToCheckNearbyBlocks = false;
            this.hasNearbyBlocks = true;
            for (EnumFacing facing : EnumFacing.values()) {
                TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tileEntity instanceof TileQuarryProxy && ((TileQuarryProxy)tileEntity).facing.value == facing.func_176734_d()) continue;
                this.hasNearbyBlocks = false;
                break;
            }
        }
        return this.hasNearbyBlocks;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.hasNearbyBlocks() && super.onBlockActivated(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public void func_73660_a() {
        Map enchantments;
        Integer integer;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.hasNearbyBlocks()) {
            return;
        }
        if (this.redstoneDirty) {
            this.redstoneDirty = false;
            this.redstoneActive = false;
            for (EnumFacing facing : EnumFacing.values()) {
                TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (!(tileEntity instanceof TileQuarryProxy) || ((TileQuarryProxy)tileEntity).facing.value != facing.func_176734_d() || !((TileQuarryProxy)tileEntity).isPowered()) continue;
                this.redstoneActive = true;
                break;
            }
        }
        if (!((RedstoneState)((Object)this.redstone_state.value)).acceptableValue(this.redstoneActive)) {
            return;
        }
        long time = this.field_145850_b.func_82737_E();
        if (this.last_tick_time == -1L || time != this.last_tick_time) {
            this.last_tick_time = time;
            if (this.num_ticks > 0) {
                if (this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                    --this.num_ticks;
                } else {
                    for (EnumFacing enumFacing : EnumFacing.values()) {
                        if (this.field_145850_b.field_73012_v.nextInt(200) >= this.num_ticks) continue;
                        this.field_145850_b.func_175718_b(2004, this.field_174879_c.func_177972_a(enumFacing), 0);
                    }
                    if (this.num_ticks > 200) {
                        this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 6.0f, true);
                    }
                }
            }
        } else {
            ++this.num_ticks;
        }
        int numOps = 1;
        ItemStack enchantsStack = this.enchants.getStack();
        if (StackHelper.isNonNull(enchantsStack) && (integer = (Integer)(enchantments = EnchantmentHelper.func_82781_a((ItemStack)enchantsStack)).get(Enchantments.field_185305_q)) != null) {
            numOps += integer.intValue();
        }
        for (int rep_i = 0; rep_i < numOps; ++rep_i) {
            if (this.extraStacks.stacks.isEmpty() && this.energy.extractEnergy(ENERGY_PER_OPERATION, true) == ENERGY_PER_OPERATION) {
                float hardness;
                IBlockState state;
                WorldServer miningWorld = WorldProviderSpecialDim.getWorld();
                if (this.posKey == null) {
                    this.getNextChunk();
                }
                if (this.fakePlayer == null) {
                    this.fakePlayer = new XUFakePlayer(miningWorld, this.owner, Lang.getItemName(this.getXUBlock()));
                }
                if (StackHelper.isNull(this.diggerTool)) {
                    this.diggerTool = genericDigger.func_77946_l();
                    if (StackHelper.isNonNull(enchantsStack)) {
                        EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)enchantsStack), (ItemStack)this.diggerTool);
                    }
                }
                while (true) {
                    this.setBlockPos();
                    state = miningWorld.func_180495_p((BlockPos)this.digPos);
                    if (state.func_177230_c().isAir(state, (IBlockAccess)miningWorld, (BlockPos)this.digPos)) {
                        this.advance();
                        continue;
                    }
                    float f = hardness = state.func_185904_a().func_76224_d() ? 0.0f : state.func_185903_a((EntityPlayer)this.fakePlayer, (World)miningWorld, (BlockPos)this.digPos);
                    if (hardness > 0.0f) break;
                    this.advance();
                }
                this.lastBiome = miningWorld.getBiomeForCoordsBody((BlockPos)this.digPos);
                float f = hardness = state.func_185904_a().func_76224_d() ? 0.0f : state.func_185903_a((EntityPlayer)this.fakePlayer, (World)miningWorld, (BlockPos)this.digPos);
                if (hardness > 0.0f) {
                    this.fakePlayer.func_184611_a(EnumHand.MAIN_HAND, this.diggerTool.func_77946_l());
                    this.fakePlayer.setLocationEdge((BlockPos)this.digPos, EnumFacing.DOWN);
                    ItemCaptureHandler.startCapturing();
                    XPCaptureHandler.startCapturing();
                    try {
                        this.fakePlayer.field_71134_c.func_180237_b((BlockPos)this.digPos);
                    }
                    catch (Throwable err) {
                        XPCaptureHandler.stopCapturing();
                        ItemCaptureHandler.stopCapturing();
                        throw Throwables.propagate((Throwable)err);
                    }
                    ++this.blocksMined.value;
                    XPCaptureHandler.stopCapturing();
                    LinkedList<ItemStack> stacks = ItemCaptureHandler.stopCapturing();
                    for (ItemStack stack : stacks) {
                        if (!this.filter.matches(stack)) continue;
                        this.extraStacks.addStack(stack);
                    }
                    this.fakePlayer.func_184611_a(EnumHand.MAIN_HAND, StackHelper.empty());
                    InventoryPlayer inventory = this.fakePlayer.field_71071_by;
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        ItemStack stack = inventory.func_70301_a(i);
                        if (!StackHelper.isNonNull(stack) || StackHelper.getStacksize(stack) <= 0 || !this.filter.matches(stack)) continue;
                        this.extraStacks.addStack(stack);
                    }
                    this.fakePlayer.clearInventory();
                    this.energy.extractEnergy(ENERGY_PER_OPERATION, false);
                }
                this.advance();
            }
            if (this.extraStacks.stacks.isEmpty()) continue;
            for (BlockPos offset_pos : new ListRandomOffset<BlockPos>(offset)) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vec3i)offset_pos));
                if (tile == null) continue;
                for (EnumFacing facing : new ListRandomOffset<EnumFacing>(offset_sides.get(offset_pos))) {
                    IItemHandler handler = CapGetter.ItemHandler.getInterface((ICapabilityProvider)tile, facing);
                    if (handler == null) continue;
                    this.extraStacks.attemptDump(handler);
                }
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        super.onNeighborBlockChange(worldIn, pos, state, neighborBlock);
        this.needsToCheckNearbyBlocks = true;
    }

    private void setBlockPos() {
        int value = this.curBlockLocation.value;
        int y = this.getY(value);
        int x = this.getX(value);
        int z = this.getZ(value);
        this.digPos.func_181079_c((this.chunkPos.field_77276_a << 4) + x, y, (this.chunkPos.field_77275_b << 4) + z);
    }

    private int getZ(int value) {
        return value >> 12 & 0xF;
    }

    private int getX(int value) {
        return value >> 8 & 0xF;
    }

    private void advance() {
        int value;
        int y;
        if ((y = this.getY(value = this.curBlockLocation.value++)) > 0) {
            return;
        }
        int x = this.getX(value);
        int z = this.getZ(value);
        if (y < 0 || y == 0 && x == 15 && z == 15) {
            this.getNewChunk();
        }
    }

    private void getNewChunk() {
        WorldProviderSpecialDim.releaseChunk(this.posKey);
        this.curBlockLocation.value = 0;
        this.posKey = null;
        this.chunkPos = null;
        this.getNextChunk();
    }

    private int getY(int value) {
        return 255 - (value & 0xFF);
    }

    private void getNextChunk() {
        this.posKey = WorldProviderSpecialDim.prepareNewChunk(this.biomeHandler.getBiome());
        this.chunkPos = WorldProviderSpecialDim.adjustChunkRef(this.posKey);
        this.curBlockLocation.value = 0;
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerQuarry(player);
    }

    static {
        BlockPos origin = BlockPos.field_177992_a;
        for (EnumFacing facing1 : EnumFacing.values()) {
            BlockPos offset1 = origin.func_177972_a(facing1);
            for (EnumFacing facing2 : EnumFacing.values()) {
                if (facing1 == facing2.func_176734_d()) continue;
                BlockPos offset2 = offset1.func_177972_a(facing2);
                if (!offset.contains(offset2)) {
                    offset.add(offset2);
                }
                offset_sides.computeIfAbsent(offset2, t -> new ArrayList()).add(facing2.func_176734_d());
            }
        }
    }

    public class ContainerQuarry
    extends DynamicContainerTile {
        public ContainerQuarry(EntityPlayer player) {
            super(TileQuarry.this);
            this.addTitle("Quantum Quarry");
            this.addWidget(new SingleStackHandlerFilter.WidgetSlotFilter(TileQuarry.this.filter, 4, 20){

                @Override
                @SideOnly(value=Side.CLIENT)
                public List<String> getToolTip() {
                    if (!this.func_75216_d()) {
                        return Minecraft.func_71410_x().field_71466_p.func_78271_c(Lang.translate("If present, the quarry will auto-destroy any items that do NOT match the filter."), 120);
                    }
                    return null;
                }
            });
            this.addWidget(new WidgetSlotItemHandler(TileQuarry.this.enchants, 0, 4, 38){

                @Override
                @SideOnly(value=Side.CLIENT)
                public List<String> getToolTip() {
                    if (!this.func_75216_d()) {
                        return ImmutableList.of((Object)Lang.translate("Enchanted Book"));
                    }
                    return null;
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                    super.renderBackground(manager, gui, guiLeft, guiTop);
                    if (!this.func_75216_d()) {
                        ItemStack stack = ItemIngredients.Type.ENCHANTED_BOOK_SKELETON.newStack();
                        gui.renderStack(stack, guiLeft + this.getX() + 1, guiTop + this.getY() + 1, "");
                    }
                }
            });
            this.addWidget(TileQuarry.this.biomeHandler.getSlot(4, 56));
            this.addWidget(new WidgetEnergyStorage(140, 20, (IEnergyStorage)TileQuarry.this.energy));
            this.addWidget(RedstoneState.getRSWidget(4, 75, TileQuarry.this.redstone_state));
            this.crop();
            this.addWidget(new WidgetTextData(26, 20, 110, 54, 1, 0x404040){

                @Override
                public void addToDescription(XUPacketBuffer packet) {
                    packet.writeInt(TileQuarry.this.getY(TileQuarry.this.curBlockLocation.value));
                    packet.writeLong(TileQuarry.this.blocksMined.value);
                    packet.writeInt(TileQuarry.this.lastBiome != null ? Biome.field_185377_q.func_148757_b((Object)TileQuarry.this.lastBiome) : -1);
                }

                @Override
                protected String constructText(XUPacketBuffer packet) {
                    int y = packet.readInt();
                    long mined = packet.readLong();
                    int biomeID = packet.readInt();
                    Biome biome = biomeID != -1 ? (Biome)Biome.field_185377_q.func_148754_a(biomeID) : null;
                    return Lang.translateArgs("Quarry Level: %s", y) + "\n" + Lang.translateArgs("Blocks Mined: %s", mined) + (biome != null ? "\n" + Lang.translateArgs("Biome: %s", biome.func_185359_l()) : "");
                }
            });
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }
}

