/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.IRegisterItemColors;
import com.rwtema.extrautils2.backend.XUItemFlat;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.compatibility.XUShapedRecipe;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.crafting.PlayerSpecificCrafting;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.datastructures.GetterSetter;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;

public class ItemUnstableIngots
extends XUItemFlat
implements IRegisterItemColors {
    public static final String[][] textures = new String[][]{{"unstable_ingot_outline", "unstable_ingot_interior", "unstable_ingot_ghost"}, {"unstable_nugget_outline", "unstable_nugget_interior", "unstable_nugget_ghost"}};
    public static int TIME_OUT = 200;
    public static HashSet<Class<?>> ALLOWED_CLASSES = Sets.newHashSet((Object[])new Class[]{ContainerWorkbench.class});
    private static int cooldown = 0;

    public ItemUnstableIngots() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_77627_a(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addItemColors(ItemColors itemColors, BlockColors blockColors) {
        itemColors.func_186730_a(this::getColorFromItemstack, new Item[]{this});
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        NBTTagCompound tagCompound;
        long baseTime;
        World world = ExtraUtils2.proxy.getClientWorld();
        if (world != null && stack.func_77960_j() == 0 && stack.func_77942_o() && (baseTime = (tagCompound = (NBTTagCompound)Validate.notNull((Object)stack.func_77978_p())).func_74763_f("time")) > 0L) {
            float time = (float)((long)TIME_OUT + baseTime - world.func_82737_E()) - MCTimer.renderPartialTickTime + (float)(tintIndex * 3);
            if (time < 0.0f) {
                return ColorHelper.colorClamp(1.0f, 0.5f + (world.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.3f, 0.0f, 1.0f);
            }
            if (time > (float)TIME_OUT) {
                return -1;
            }
            float v = time / (float)TIME_OUT;
            double v1 = Math.log(v) * -15.49 * 2.0;
            float g = 0.5f + (float)Math.cos(v1) * 0.3f + 0.2f * v;
            return ColorHelper.colorClamp(1.0f, g, g * v, 1.0f);
        }
        if (tintIndex == 2) {
            return 0;
        }
        return -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        for (String[] texture : textures) {
            Textures.register(texture);
        }
    }

    @Override
    public void getSubItemsBase(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (int i = 0; i < 3; ++i) {
            subItems.add(new ItemStack(itemIn, 1, i));
        }
    }

    @Override
    public int getMaxMetadata() {
        return 2;
    }

    @Override
    public String getTexture(@Nullable ItemStack itemStack, int renderPass) {
        if (itemStack == null) {
            return textures[0][0];
        }
        return textures[itemStack.func_77960_j() % 2][renderPass % 2];
    }

    @Override
    public int getRenderLayers(@Nullable ItemStack itemStack) {
        return 2;
    }

    @Override
    public boolean renderLayerIn3D(ItemStack stack, int renderPass) {
        return renderPass == 0;
    }

    public int getItemStackLimit(ItemStack stack) {
        if (stack.func_77960_j() == 0) {
            return 1;
        }
        return 64;
    }

    @Override
    public int getTint(ItemStack stack, int i) {
        return i;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77960_j() == 0) {
            cooldown = TIME_OUT * 2;
        }
    }

    public void addRecipes() {
        CraftingHelper.addRecipe(new UnstableIngotRecipe(CraftingHelper.createLocation("unstable_ingot")));
        CraftingHelper.addShaped("unstable_nugget", XU2Entries.unstableIngots.newStack(1, 1), "i", "d", "s", Character.valueOf('i'), "nuggetIron", Character.valueOf('d'), "stickWood", Character.valueOf('s'), "gemDiamond");
        CraftingHelper.addShaped("stable_unstable_ingot", XU2Entries.unstableIngots.newStack(1, 2), "nnn", "nnn", "nnn", Character.valueOf('n'), XU2Entries.unstableIngots.newStack(1, 1));
        CraftingHelper.addShapeless("unstable_unpack", XU2Entries.unstableIngots.newStack(9, 1), XU2Entries.unstableIngots.newStack(1, 2));
    }

    @SubscribeEvent
    public void checkForExplosion(TickEvent.ServerTickEvent event) {
        if (cooldown > 0) {
            --cooldown;
        }
    }

    @SubscribeEvent
    public void checkForExplosion(TickEvent.PlayerTickEvent event) {
        ItemStack stack;
        int windowId;
        if (cooldown == 0 || event.player.field_70170_p.field_72995_K) {
            return;
        }
        Container openContainer = event.player.field_71070_bA;
        LinkedList itemStacks = Lists.newLinkedList();
        InventoryPlayer inventory = event.player.field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            itemStacks.add(new GetterSetter.InvSlot((IInventory)inventory, i));
        }
        itemStacks.add(new GetterSetter.PlayerHand(inventory));
        if (openContainer == null || openContainer == event.player.field_71069_bz) {
            windowId = -1;
        } else {
            windowId = openContainer.field_75152_c;
            for (Slot slot : openContainer.field_75151_b) {
                itemStacks.add(new GetterSetter.ContainerSlot(slot));
            }
        }
        LinkedList stacks = Lists.newLinkedList();
        for (GetterSetter getterSetter : itemStacks) {
            NBTTagCompound tag;
            stack = (ItemStack)getterSetter.get();
            if (StackHelper.isNull(stack) || stack.func_77973_b() != this || (tag = stack.func_77978_p()) == null || !tag.func_150297_b("time", 99)) continue;
            cooldown = TIME_OUT * 2;
            if (tag.func_74763_f("time") + (long)TIME_OUT > event.player.field_70170_p.func_82737_E() && tag.func_74762_e("dim") == event.player.field_70170_p.field_73011_w.getDimension() && tag.func_74762_e("container") == windowId) continue;
            stacks.add(getterSetter);
        }
        if (stacks.isEmpty()) {
            return;
        }
        for (GetterSetter stackGetterSetter : stacks) {
            stack = (ItemStack)stackGetterSetter.get();
            StackHelper.setStackSize(stack, 0);
            stackGetterSetter.accept(StackHelper.empty());
        }
        this.explodePlayer(event.player);
        if (windowId != -1) {
            event.player.func_71053_j();
        }
        event.player.field_71069_bz.func_75142_b();
    }

    @SubscribeEvent
    public void onPlayerEvent(PlayerEvent event) {
        cooldown = TIME_OUT * 20;
    }

    @SubscribeEvent
    public void onToss(ItemTossEvent event) {
        ItemStack stack = event.getEntityItem().func_92059_d();
        if (stack.func_77973_b() != this) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_150297_b("time", 99)) {
            return;
        }
        if (!event.getEntityItem().field_70170_p.field_72995_K) {
            this.explodePlayer(event.getPlayer());
        }
        event.getEntityItem().func_92058_a(StackHelper.empty());
        event.getEntityItem().func_70106_y();
    }

    private void explodePlayer(EntityPlayer player) {
        player.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)player).func_76348_h().func_151518_m(), 1000.0f);
        player.field_70170_p.func_72885_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, 6.0f, true, false);
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return super.onDroppedByPlayer(item, player);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return super.createEntity(world, location, itemstack);
    }

    @Override
    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        if (stack.func_77960_j() == 0 && playerIn != null && playerIn.field_71070_bA != null && playerIn.field_71070_bA != playerIn.field_71069_bz) {
            NBTTagCompound tag = NBTHelper.getOrInitTagCompound(stack);
            NBTTagCompound profile = NBTHelper.proifleToNBT(playerIn.func_146103_bH());
            tag.func_74782_a("owner", (NBTBase)profile);
            tag.func_74768_a("container", playerIn.field_71070_bA.field_75152_c);
            tag.func_74768_a("dim", playerIn.field_70170_p.field_73011_w.getDimension());
            tag.func_74772_a("time", playerIn.field_70170_p.func_82737_E());
            stack.func_77982_d(tag);
            if (!worldIn.field_72995_K) {
                cooldown = TIME_OUT * 2;
            }
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + stack.func_77960_j();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (stack.func_77960_j() == 0) {
            World world = ExtraUtils2.proxy.getClientWorld();
            if (world != null && stack.func_77942_o()) {
                NBTTagCompound tagCompound = (NBTTagCompound)Validate.notNull((Object)stack.func_77978_p());
                float time = (float)((long)TIME_OUT + tagCompound.func_74763_f("time") - world.func_82737_E()) / 20.0f;
                if (time > 0.0f) {
                    tooltip.add(Lang.translateArgs("Explosion in %s", StringHelper.format(time)));
                }
            } else {
                tooltip.add(Lang.translate("ERROR: Divide by diamond"));
                tooltip.add(Lang.translate("This ingot is highly unstable and will explode after 10 seconds."));
                tooltip.add(Lang.translate("Will also explode if the crafting window is closed or the ingot is thrown on the ground."));
                tooltip.add(Lang.translate("Additionally these ingots do not stack"));
                tooltip.add(Lang.translate(" - Do not craft unless ready -"));
                tooltip.add("");
                tooltip.add(Lang.translate("Must be crafted in a vanilla crafting table."));
            }
        }
    }

    public static class UnstableIngotRecipe
    extends PlayerSpecificCrafting {
        public UnstableIngotRecipe(ResourceLocation location) {
            super(location, new XUShapedRecipe(location, XU2Entries.unstableIngots.newStack(1, 0), "i", "d", "s", Character.valueOf('i'), "ingotIron", Character.valueOf('d'), "stickWood", Character.valueOf('s'), "gemDiamond"));
        }

        @Override
        @Nullable
        public int[] getDimensions() {
            return new int[]{1, 3};
        }

        @Override
        public List<List<ItemStack>> getInputList() {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)OreDictionary.getOres((String)"ingotIron"));
            builder.add((Object)OreDictionary.getOres((String)"stickWood"));
            builder.add((Object)OreDictionary.getOres((String)"gemDiamond"));
            return builder.build();
        }

        @Override
        public ItemStack func_77571_b() {
            return super.func_77571_b();
        }

        @Override
        protected void updatePlayer(EntityPlayerMP foundPlayer) {
        }

        @Override
        protected boolean isValidForCrafting(EntityPlayer foundPlayer) {
            return foundPlayer.field_71070_bA != null && ALLOWED_CLASSES.contains(foundPlayer.field_71070_bA.getClass());
        }

        @Override
        public String info() {
            return null;
        }

        @Override
        protected void finishedCrafting(EntityPlayer player, ItemStack recipeOutput) {
        }

        @Override
        protected void addTooltip(ItemTooltipEvent event, ItemStack itemStack) {
        }
    }
}

