/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.itemhandler;

import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.itemhandler.IItemHandlerModifiableCompat;
import com.rwtema.extrautils2.itemhandler.IItemHandlerUpdate;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class SingleStackHandlerBase
implements IItemHandlerModifiableCompat,
IItemHandlerUpdate {
    @ItemStackNonNull
    public abstract ItemStack getStack();

    public abstract void setStack(@ItemStackNonNull ItemStack var1);

    @Override
    public void setStackInSlot(int slot, @ItemStackNonNull ItemStack stack) {
        if (ItemStack.func_77989_b((ItemStack)this.getStack(), (ItemStack)stack)) {
            return;
        }
        this.setStack(stack);
        this.onContentsChanged();
    }

    @Override
    public int getSlots() {
        return 1;
    }

    @Override
    @ItemStackNonNull
    public ItemStack getStackInSlot(int slot) {
        return this.getStack();
    }

    @Override
    @ItemStackNonNull
    public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
        if (StackHelper.isNull(stack) || StackHelper.isEmpty(stack)) {
            return StackHelper.empty();
        }
        int limit = this.getStackLimit(stack);
        if (limit <= 0) {
            return stack;
        }
        ItemStack curStack = this.getStack();
        if (StackHelper.isNonNull(curStack)) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)curStack)) {
                return stack;
            }
            if ((limit -= StackHelper.getStacksize(curStack)) <= 0) {
                return stack;
            }
        }
        boolean reachedLimit = StackHelper.getStacksize(stack) > limit;
        stack = StackHelper.safeCopy(stack);
        if (!simulate) {
            if (StackHelper.isNull(curStack)) {
                this.setStack(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                StackHelper.increase(curStack, reachedLimit ? limit : StackHelper.getStacksize(stack));
                this.setStack(curStack);
            }
            this.onContentsChanged();
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(StackHelper.getStacksize(stack) - limit)) : StackHelper.empty();
    }

    @Override
    public void onChange(int index) {
        this.onContentsChanged();
    }

    @Override
    @ItemStackNonNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int toExtract;
        if (amount == 0) {
            return StackHelper.empty();
        }
        ItemStack existing = this.getStack();
        if (StackHelper.isNull(existing)) {
            return StackHelper.empty();
        }
        int n = toExtract = amount == 1 ? 1 : Math.min(amount, existing.func_77976_d());
        if (StackHelper.getStacksize(existing) <= toExtract) {
            if (!simulate) {
                this.setStack(StackHelper.empty());
                this.onContentsChanged();
            }
            return existing;
        }
        if (!simulate) {
            StackHelper.decrease(existing, toExtract);
            this.setStack(existing);
            this.onContentsChanged();
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    protected int getStackLimit(@Nonnull ItemStack stack) {
        return stack.func_77976_d();
    }

    protected void onContentsChanged() {
    }

    public boolean canInsertAll(ItemStack stack) {
        if (StackHelper.isNull(stack)) {
            return false;
        }
        ItemStack item = this.insertItem(0, stack, true);
        return StackHelper.isNull(item);
    }

    public boolean canExtractAll(int amount) {
        ItemStack item = this.extractItem(0, amount, true);
        return StackHelper.isNonNull(item) && StackHelper.getStacksize(item) == amount;
    }

    public boolean isFull() {
        ItemStack curStack = this.getStack();
        return StackHelper.isNonNull(curStack) && StackHelper.getStacksize(curStack) >= curStack.func_77976_d();
    }

    public boolean isEmpty() {
        ItemStack curStack = this.getStack();
        return StackHelper.isNull(curStack) || StackHelper.isEmpty(curStack);
    }

    public int getStackLevel() {
        ItemStack curStack = this.getStack();
        return StackHelper.isNull(curStack) ? 0 : StackHelper.getStacksize(curStack);
    }
}

