/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.XUBlockStaticRotation;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.tile.TileTrashCan;
import com.rwtema.extrautils2.tile.TileTrashCanEnergy;
import com.rwtema.extrautils2.tile.TileTrashCanFluids;
import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class BlockTrashCan
extends XUBlockStaticRotation {
    private String suffix;

    public BlockTrashCan() {
        this("");
    }

    public BlockTrashCan(String suffix) {
        super(Material.field_151576_e);
        this.suffix = suffix;
        ExtraUtils2.proxy.registerTexture("trashcan", "trashcan_top", "trashcan_bottom");
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    @Override
    protected BoxModel createBaseModel(IBlockState state) {
        BoxModel model = new BoxModel();
        model.addBox(0.125f, 0.0f, 0.125f, 0.875f, 0.625f, 0.875f);
        model.addBox(0.0625f, 0.625f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        model.addBox(0.3125f, 0.875f, 0.4375f, 0.6875f, 0.9375f, 0.5625f);
        model.setTextures("trashcan" + this.suffix, EnumFacing.DOWN, "trashcan_bottom" + this.suffix, EnumFacing.UP, "trashcan_top" + this.suffix);
        return model;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileTrashCan();
    }

    public static class Energy
    extends BlockTrashCan {
        public Energy() {
            super("_energy");
        }

        @Override
        @Nonnull
        public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
            return new TileTrashCanEnergy();
        }
    }

    public static class Fluid
    extends BlockTrashCan {
        public Fluid() {
            super("_fluid");
        }

        @Override
        @Nonnull
        public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
            return new TileTrashCanFluids();
        }
    }
}

