/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.api.machine.XUMachineEnchanter;
import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockConnectedTextureBase;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.compatibility.XUShapelessRecipe;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.crafting.EnchantRecipe;
import com.rwtema.extrautils2.textures.ConnectedTexture;
import com.rwtema.extrautils2.textures.ISolidWorldTexture;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.ItemStackHelper;
import com.rwtema.extrautils2.utils.helpers.OreDicHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class BlockDecorativeSolidWood
extends XUBlockConnectedTextureBase {
    public static final PropertyEnumSimple<DecorStates> decor = new PropertyEnumSimple<DecorStates>(DecorStates.class);

    public BlockDecorativeSolidWood() {
        super(Material.field_151575_d);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        for (DecorStates decorState : DecorStates.values()) {
            decorState.tex = decorState.createTexture(this);
        }
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator((XUBlock)this, false, new IProperty[]{decor});
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    @Override
    public ISolidWorldTexture getConnectedTexture(IBlockState state, EnumFacing side) {
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeSolidWood.decor))).tex;
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return 0.0f;
        }
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeSolidWood.decor))).enchantBonus;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ((DecorStates)((Object)this.xuBlockState.getStateFromItemStack(stack).func_177229_b((IProperty)decor))).addInformation(stack, playerIn, tooltip, advanced);
    }

    public static enum DecorStates implements IItemStackMaker
    {
        magical_planks{
            {
                this.enchantBonus = 0.625f;
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless("magic_wood_planks", this.newStack(4), magical_wood.newStack(1));
            }
        }
        ,
        magical_wood{
            {
                this.enchantBonus = 2.5f;
            }

            @Override
            public void addRecipes() {
                OreDictionary.registerOre((String)"blockMagicalWood", (ItemStack)this.newStack());
                OreDicHelper.extendVanillaOre("bookshelf", Blocks.field_150342_X);
                ResourceLocation resourceLocation = CraftingHelper.createLocation("magic_wood");
                CraftingHelper.addRecipe(new EnchantRecipe(resourceLocation, new XUShapelessRecipe(resourceLocation, this.newStack(1), "bookshelf", "ingotGold"), 4, (List<List<ItemStack>>)ImmutableList.of((Object)OreDictionary.getOres((String)"bookshelf"), (Object)OreDictionary.getOres((String)"ingotGold")), null));
                if (XU2Entries.machineEntry.isActive()) {
                    XUMachineEnchanter.addRecipe((List<ItemStack>)OreDictionary.getOres((String)"bookshelf"), 1, this.newStack(), 1, 64000, "gemLapis");
                }
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                ItemStackHelper.addInfoWidth(tooltip, stack, Lang.translate("Boosts max level of enchanting tables by 2.5 levels"));
            }
        }
        ,
        diagonalwood{

            @Override
            public void addRecipes() {
                CraftingHelper.addShaped("diagonal_wood", this.newStack(5), "SR", "RS", Character.valueOf('S'), "stairWood", Character.valueOf('R'), "plankWood");
            }
        };

        @SideOnly(value=Side.CLIENT)
        public ISolidWorldTexture tex;
        public float enchantBonus = 0.0f;

        public abstract void addRecipes();

        @Override
        public ItemStack newStack(int amount) {
            return XU2Entries.decorativeSolidWood.newStack(amount, new Object[]{decor, this});
        }

        public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        }

        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public ISolidWorldTexture createTexture(XUBlockConnectedTextureBase block) {
            return new ConnectedTexture(this.toString(), block.xuBlockState.defaultState.func_177226_a((IProperty)decor, (Comparable)((Object)this)), block);
        }

        @Override
        public ItemStack newStack() {
            return this.newStack(1);
        }
    }
}

