/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.asm;

import com.google.common.collect.Sets;
import com.rwtema.extrautils2.asm.ClassTransformerHandler;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class LightingTransformer
implements IClassTransformer {
    Set<String> getLightFor = Sets.newHashSet((Object[])new String[]{"getLightFor", "func_175642_b"});
    Set<String> getLightFromNeighborsFor = Sets.newHashSet((Object[])new String[]{"getLightFromNeighborsFor", "func_175705_a"});
    Set<String> getLightForExt = Sets.newHashSet((Object[])new String[]{"getLightForExt", "func_175629_a"});
    Set<String> exceptions = Sets.newHashSet((Object[])new String[]{"checkLightFor", "getRawLight", "func_180500_c", "func_175638_a"});
    Set<String> getLightSubtracted = Sets.newHashSet((Object[])new String[]{"getLightSubtracted", "func_177443_a"});
    Set<String> world = Sets.newHashSet((Object[])new String[]{"world", "field_72815_e", "field_76637_e"});

    public byte[] transform(String s2, String s, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        switch (s) {
            case "net.minecraft.world.chunk.Chunk": {
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(bytes);
                classReader.accept((ClassVisitor)classNode, 0);
                String getLightSubtractedName = null;
                MethodNode m = null;
                String passThru = "getLightSubtractedPassThru";
                for (MethodNode method : classNode.methods) {
                    if (!this.getLightSubtracted.contains(method.name)) continue;
                    m = method;
                    getLightSubtractedName = method.name;
                    method.name = passThru;
                }
                String worldObjFieldName = this.getField(classNode, this.world);
                if (getLightSubtractedName == null || worldObjFieldName == null) {
                    ClassTransformerHandler.logger.info("Chunk Failed - " + getLightSubtractedName + " " + worldObjFieldName);
                    return bytes;
                }
                MethodNode methodNode = new MethodNode(m.access, getLightSubtractedName, m.desc, m.signature, m.exceptions.toArray(new String[m.exceptions.size()]));
                methodNode.visitCode();
                methodNode.visitVarInsn(25, 0);
                methodNode.visitFieldInsn(180, "net/minecraft/world/chunk/Chunk", worldObjFieldName, "Lnet/minecraft/world/World;");
                methodNode.visitVarInsn(25, 1);
                methodNode.visitVarInsn(25, 0);
                methodNode.visitVarInsn(25, 1);
                methodNode.visitVarInsn(21, 2);
                methodNode.visitMethodInsn(182, "net/minecraft/world/chunk/Chunk", passThru, m.desc, false);
                methodNode.visitMethodInsn(184, "com/rwtema/extrautils2/asm/Lighting", "getCombinedLight", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;I)I", false);
                methodNode.visitInsn(172);
                classNode.methods.add(methodNode);
                ClassWriter writer = new ClassWriter(1);
                classNode.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
            case "net.minecraft.world.World": {
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(bytes);
                classReader.accept((ClassVisitor)classNode, 0);
                if (this.overrideType(classNode, this.getLightFor, this.exceptions)) {
                    ClassTransformerHandler.logger.info("World failed -" + this.getLightFor.toString() + " " + this.exceptions.toString());
                    return bytes;
                }
                if (FMLLaunchHandler.side() == Side.CLIENT && this.overrideType(classNode, this.getLightFromNeighborsFor, null)) {
                    ClassTransformerHandler.logger.info("World failed -" + this.getLightFromNeighborsFor.toString());
                }
                ClassWriter writer = new ClassWriter(1);
                classNode.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
            case "net.minecraft.world.ChunkCache": {
                if (FMLLaunchHandler.side() != Side.CLIENT) {
                    return bytes;
                }
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(bytes);
                classReader.accept((ClassVisitor)classNode, 0);
                String getLightForExtName = null;
                MethodNode m = null;
                String passThru = "getLightForExtPassThru";
                for (MethodNode method : classNode.methods) {
                    if (!this.getLightForExt.contains(method.name)) continue;
                    m = method;
                    getLightForExtName = method.name;
                    method.name = passThru;
                }
                String worldObjFieldName = this.getField(classNode, this.world);
                if (getLightForExtName == null || worldObjFieldName == null) {
                    ClassTransformerHandler.logger.info("Chunk Failed - " + getLightForExtName + " " + (String)worldObjFieldName);
                    return bytes;
                }
                MethodNode methodNode = new MethodNode(m.access, getLightForExtName, m.desc, m.signature, m.exceptions.toArray(new String[m.exceptions.size()]));
                methodNode.visitCode();
                methodNode.visitVarInsn(25, 0);
                methodNode.visitFieldInsn(180, "net/minecraft/world/ChunkCache", worldObjFieldName, "Lnet/minecraft/world/World;");
                methodNode.visitVarInsn(25, 1);
                methodNode.visitVarInsn(25, 2);
                methodNode.visitVarInsn(25, 0);
                methodNode.visitVarInsn(25, 1);
                methodNode.visitVarInsn(25, 2);
                methodNode.visitMethodInsn(182, "net/minecraft/world/ChunkCache", passThru, m.desc, false);
                methodNode.visitMethodInsn(184, "com/rwtema/extrautils2/asm/Lighting", "getLightFor", "(Lnet/minecraft/world/World;Lnet/minecraft/world/EnumSkyBlock;Lnet/minecraft/util/math/BlockPos;I)I", false);
                methodNode.visitInsn(172);
                classNode.methods.add(methodNode);
                ClassWriter writer = new ClassWriter(1);
                classNode.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        }
        return bytes;
    }

    public String getField(ClassNode classNode, Set<String> fieldNames) {
        String fieldName = null;
        for (FieldNode field : classNode.fields) {
            if (!fieldNames.contains(field.name)) continue;
            fieldName = field.name;
            break;
        }
        return fieldName;
    }

    private boolean overrideType(ClassNode classNode, Set<String> methodName, Set<String> exceptions) {
        String getLightForName = null;
        MethodNode m = null;
        String passThru = null;
        for (MethodNode method : classNode.methods) {
            if (!methodName.contains(method.name)) continue;
            m = method;
            getLightForName = method.name;
            method.name = passThru = getLightForName + "Implementation";
            break;
        }
        if (getLightForName == null) {
            return true;
        }
        if (exceptions != null) {
            for (MethodNode method : classNode.methods) {
                if (!exceptions.contains(method.name)) continue;
                for (AbstractInsnNode next : method.instructions) {
                    if (next.getType() != 5) continue;
                    MethodInsnNode methodNode = (MethodInsnNode)next;
                    if (!getLightForName.equals(methodNode.name)) continue;
                    methodNode.name = passThru;
                }
            }
        }
        MethodNode methodNode = new MethodNode(m.access, getLightForName, m.desc, m.signature, m.exceptions.toArray(new String[0]));
        methodNode.visitCode();
        methodNode.visitVarInsn(25, 0);
        methodNode.visitVarInsn(25, 1);
        methodNode.visitVarInsn(25, 2);
        methodNode.visitVarInsn(25, 0);
        methodNode.visitVarInsn(25, 1);
        methodNode.visitVarInsn(25, 2);
        methodNode.visitMethodInsn(182, "net/minecraft/world/World", passThru, m.desc, false);
        methodNode.visitMethodInsn(184, "com/rwtema/extrautils2/asm/Lighting", "getLightFor", "(Lnet/minecraft/world/World;Lnet/minecraft/world/EnumSkyBlock;Lnet/minecraft/util/math/BlockPos;I)I", false);
        methodNode.visitInsn(172);
        classNode.methods.add(methodNode);
        return false;
    }
}

