/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableSet;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.farming.IFarmProperties;
import forestry.api.modules.ForestryModule;
import forestry.core.ModuleCore;
import forestry.core.circuits.Circuits;
import forestry.core.config.Config;
import forestry.core.items.EnumElectronTube;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.Log;
import forestry.farming.FarmRegistry;
import forestry.farming.circuits.CircuitFarmLogic;
import forestry.farming.logic.FarmLogicRedOrchid;
import forestry.farming.logic.farmables.FarmableAgingCrop;
import forestry.plugins.CompatPlugin;
import java.util.Collections;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@ForestryModule(containerID="forestry_compat", moduleID="extra.utilities", name="Extra Utilities", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.extrautilities.description")
public class PluginExtraUtilities
extends CompatPlugin {
    public static ItemStack orchidStack = ItemStack.field_190927_a;

    public PluginExtraUtilities() {
        super("Extra Utilities", "extrautils2");
    }

    @Override
    public void doInit() {
        Item item;
        Block redOrchid = this.getBlock("redorchid");
        Block enderLilly = this.getBlock("enderlilly");
        if (Config.isExUtilRedOrchidEnabled() && redOrchid != null) {
            item = Item.func_150898_a((Block)redOrchid);
            this.registerFarmable(redOrchid, item, new ItemStack(Items.field_151137_ax), "farmOrchid");
            IFarmProperties orchidFarm = FarmRegistry.getInstance().registerLogic("farmOrchid", FarmLogicRedOrchid::new, new String[0]);
            orchidFarm.registerSoil(new ItemStack(Blocks.field_150450_ax), Blocks.field_150450_ax.func_176223_P());
            orchidFarm.registerSoil(new ItemStack(Blocks.field_150439_ay), Blocks.field_150439_ay.func_176223_P());
            Circuits.farmOrchidManaged = new CircuitFarmLogic("managedOrchid", orchidFarm, false);
            Circuits.farmOrchidManual = new CircuitFarmLogic("manualOrchid", orchidFarm, true);
            orchidStack = new ItemStack(item);
        }
        if (Config.isExUtilEnderLilyEnabled() && enderLilly != null) {
            item = Item.func_150898_a((Block)enderLilly);
            this.registerFarmable(enderLilly, item, new ItemStack(Items.field_151079_bi), "farmEnder");
        }
    }

    @Override
    public Set<ResourceLocation> getDependencyUids() {
        return ImmutableSet.of((Object)new ResourceLocation("forestry", "farming"));
    }

    @Override
    public void registerRecipes() {
        if (Circuits.farmOrchidManaged != null) {
            ICircuitLayout layoutManaged = ChipsetManager.circuitRegistry.getLayout("forestry.farms.managed");
            ICircuitLayout layoutManual = ChipsetManager.circuitRegistry.getLayout("forestry.farms.manual");
            if (layoutManaged == null || layoutManual == null) {
                return;
            }
            ChipsetManager.solderManager.addRecipe(layoutManaged, ModuleCore.getItems().tubes.get(EnumElectronTube.ORCHID, 1), Circuits.farmOrchidManaged);
            ChipsetManager.solderManager.addRecipe(layoutManual, ModuleCore.getItems().tubes.get(EnumElectronTube.ORCHID, 1), Circuits.farmOrchidManual);
        }
    }

    private void registerFarmable(Block plantBlock, Item plantItem, ItemStack product, String identifier) {
        IProperty<Integer> growthProperty = BlockUtil.getProperty(plantBlock, "growth", Integer.class);
        if (growthProperty == null) {
            Log.error("Could not find the growth property of {}.", plantBlock.func_149732_F());
        } else {
            FarmRegistry registry = FarmRegistry.getInstance();
            int harvestAge = (Integer)Collections.max(growthProperty.func_177700_c());
            int replantAge = (Integer)plantBlock.func_176223_P().func_177229_b(growthProperty);
            registry.registerFarmables(identifier, new FarmableAgingCrop(new ItemStack(plantItem), plantBlock, product, growthProperty, harvestAge, (Integer)replantAge));
        }
    }
}

