/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.ICoolant;
import buildcraft.api.fuels.ICoolantManager;
import buildcraft.api.mj.MjAPI;
import forestry.api.core.ForestryAPI;
import forestry.api.modules.ForestryModule;
import forestry.core.fluids.Fluids;
import forestry.core.utils.ModUtil;
import forestry.modules.BlankForestryModule;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@ForestryModule(containerID="forestry_compat", moduleID="buildcraft.fuels", name="BuildCraft 6 Fuels", author="mezz", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.buildcraft6.description")
public class PluginBuildCraftFuels
extends BlankForestryModule {
    public static final String MOD_ID = "buildcraftenergy";

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded("buildcraftlib", "[7.99.17,8.0)");
    }

    @Override
    public String getFailMessage() {
        return "Compatible BuildCraftAPI|fuels version not found";
    }

    @Override
    public void doInit() {
        Fluid ethanol;
        ICoolantManager coolantManager = BuildcraftFuelRegistry.coolant;
        if (coolantManager != null) {
            FluidStack water = new FluidStack(FluidRegistry.WATER, 1);
            ICoolant waterCoolant = coolantManager.getCoolant(water);
            Fluid ice = Fluids.ICE.getFluid();
            if (waterCoolant != null && ice != null) {
                float waterCooling = waterCoolant.getDegreesCoolingPerMB(water, 100.0f);
                coolantManager.addCoolant(ice, 6.0f * waterCooling);
            }
        }
        if ((ethanol = Fluids.BIO_ETHANOL.getFluid()) != null) {
            long ethanolPower = 4L * MjAPI.MJ;
            int ethanolBurnTime = Math.round(15000.0f * ForestryAPI.activeMode.getFloatSetting("fuel.ethanol.combustion"));
            BuildcraftFuelRegistry.fuel.addFuel(ethanol, ethanolPower, ethanolBurnTime);
        }
    }
}

