/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.network.packets;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.EnumTradeStationState;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.ITradeStationInfo;
import forestry.api.mail.PostManager;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.mail.TradeStationInfo;
import forestry.mail.gui.ILetterInfoReceiver;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketLetterInfoResponse
extends ForestryPacket
implements IForestryPacketClient {
    public final EnumAddressee type;
    @Nullable
    public final ITradeStationInfo tradeInfo;
    @Nullable
    public final IMailAddress address;

    public PacketLetterInfoResponse(EnumAddressee type, @Nullable ITradeStationInfo info, @Nullable IMailAddress address) {
        this.type = type;
        if (type == EnumAddressee.TRADER) {
            this.tradeInfo = info;
            this.address = null;
        } else if (type == EnumAddressee.PLAYER) {
            this.tradeInfo = info;
            this.address = address;
        } else {
            throw new IllegalArgumentException("Unknown addressee type: " + (Object)((Object)type));
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.LETTER_INFO_RESPONSE;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeEnum(this.type, EnumAddressee.values());
        if (this.type == EnumAddressee.PLAYER) {
            Preconditions.checkNotNull((Object)this.address);
            GameProfile profile = this.address.getPlayerProfile();
            data.writeLong(profile.getId().getMostSignificantBits());
            data.writeLong(profile.getId().getLeastSignificantBits());
            data.func_180714_a(profile.getName());
        } else if (this.type == EnumAddressee.TRADER) {
            if (this.tradeInfo == null) {
                data.writeBoolean(false);
            } else {
                data.writeBoolean(true);
                data.func_180714_a(this.tradeInfo.getAddress().getName());
                data.writeLong(this.tradeInfo.getOwner().getId().getMostSignificantBits());
                data.writeLong(this.tradeInfo.getOwner().getId().getLeastSignificantBits());
                data.func_180714_a(this.tradeInfo.getOwner().getName());
                data.func_150788_a(this.tradeInfo.getTradegood());
                data.writeItemStacks(this.tradeInfo.getRequired());
                data.writeEnum(this.tradeInfo.getState(), EnumTradeStationState.values());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            Container container = player.field_71070_bA;
            if (container instanceof ILetterInfoReceiver) {
                EnumAddressee type = (EnumAddressee)data.readEnum(EnumAddressee.values());
                TradeStationInfo tradeInfo = null;
                IMailAddress address = null;
                if (type == EnumAddressee.PLAYER) {
                    GameProfile profile = new GameProfile(new UUID(data.readLong(), data.readLong()), data.readString());
                    address = PostManager.postRegistry.getMailAddress(profile);
                } else if (type == EnumAddressee.TRADER) {
                    if (data.readBoolean()) {
                        address = PostManager.postRegistry.getMailAddress(data.readString());
                        GameProfile owner = new GameProfile(new UUID(data.readLong(), data.readLong()), data.readString());
                        ItemStack tradegood = data.func_150791_c();
                        NonNullList<ItemStack> required = data.readItemStacks();
                        EnumTradeStationState state = (EnumTradeStationState)data.readEnum(EnumTradeStationState.values());
                        tradeInfo = new TradeStationInfo(address, owner, tradegood, required, state);
                    } else {
                        tradeInfo = null;
                    }
                }
                ((ILetterInfoReceiver)container).handleLetterInfoUpdate(type, address, tradeInfo);
            }
        }
    }
}

