/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.AIButterflyBase;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.entities.EnumButterflyState;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockWall;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;

public class AIButterflyRest
extends AIButterflyBase {
    public AIButterflyRest(EntityButterfly entity) {
        super(entity);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        int z;
        if (this.entity.getExhaustion() < 1000 && this.entity.canFly()) {
            return false;
        }
        int x = (int)this.entity.field_70165_t;
        int y = (int)Math.floor(this.entity.field_70163_u);
        BlockPos pos = new BlockPos(x, y, z = (int)this.entity.field_70161_v);
        if (!this.canLand(pos)) {
            return false;
        }
        if (this.entity.field_70170_p.func_175623_d(pos = pos.func_177982_a(x, -1, z))) {
            return false;
        }
        IBlockState blockState = this.entity.field_70170_p.func_180495_p(pos);
        if (blockState.func_185904_a().func_76224_d()) {
            return false;
        }
        if (!this.entity.getButterfly().isAcceptedEnvironment(this.entity.field_70170_p, x, pos.func_177956_o(), z)) {
            return false;
        }
        this.entity.setDestination(null);
        this.entity.setState(EnumButterflyState.RESTING);
        return true;
    }

    public boolean func_75253_b() {
        if (this.entity.getExhaustion() <= 0 && this.entity.canFly()) {
            return false;
        }
        return !this.entity.func_70090_H();
    }

    public void func_75249_e() {
    }

    public void func_75251_c() {
    }

    public void func_75246_d() {
        this.entity.changeExhaustion(-1);
    }

    private boolean canLand(BlockPos pos) {
        if (!this.entity.field_70170_p.func_175667_e(pos)) {
            return false;
        }
        IBlockState blockState = this.entity.field_70170_p.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!block.func_176205_b((IBlockAccess)this.entity.field_70170_p, pos)) {
            return false;
        }
        if (AIButterflyRest.isPlant(blockState)) {
            return true;
        }
        IBlockState blockStateBelow = this.entity.field_70170_p.func_180495_p(pos.func_177977_b());
        Block blockBelow = blockStateBelow.func_177230_c();
        return AIButterflyRest.isRest(blockBelow) || blockBelow.isLeaves(blockStateBelow, (IBlockAccess)this.entity.field_70170_p, pos.func_177977_b());
    }

    private static boolean isRest(Block block) {
        if (block instanceof BlockFence) {
            return true;
        }
        return block instanceof BlockWall;
    }

    private static boolean isPlant(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        if (block instanceof BlockFlower) {
            return true;
        }
        if (block instanceof IPlantable) {
            return true;
        }
        if (block instanceof IGrowable) {
            return true;
        }
        return blockState.func_185904_a() == Material.field_151585_k;
    }
}

