/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.network.packets;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdServer;
import forestry.core.tiles.TileBase;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import forestry.factory.network.packets.PacketRecipeTransferUpdate;
import forestry.factory.tiles.TileCarpenter;
import forestry.factory.tiles.TileFabricator;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PacketRecipeTransferRequest
extends ForestryPacket
implements IForestryPacketServer {
    private final BlockPos pos;
    private final NonNullList<ItemStack> craftingInventory;

    public PacketRecipeTransferRequest(TileBase base, NonNullList<ItemStack> craftingInventory) {
        this.pos = base.func_174877_v();
        this.craftingInventory = craftingInventory;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_179255_a(this.pos);
        data.writeItemStacks(this.craftingInventory);
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.RECIPE_TRANSFER_REQUEST;
    }

    public static class Handler
    implements IForestryPacketHandlerServer {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayerMP player) throws IOException {
            BlockPos pos = data.func_179259_c();
            NonNullList<ItemStack> craftingInventory = data.readItemStacks();
            TileEntity tile = TileUtil.getTile((IBlockAccess)player.field_70170_p, pos);
            if (tile instanceof TileCarpenter) {
                TileCarpenter carpenter = (TileCarpenter)tile;
                int index = 0;
                for (ItemStack stack : craftingInventory) {
                    carpenter.getCraftingInventory().func_70299_a(index, stack);
                    ++index;
                }
                NetworkUtil.sendNetworkPacket(new PacketRecipeTransferUpdate(carpenter, craftingInventory), pos, player.field_70170_p);
            } else if (tile instanceof TileFabricator) {
                TileFabricator fabricator = (TileFabricator)tile;
                int index = 0;
                for (ItemStack stack : craftingInventory) {
                    fabricator.getCraftingInventory().func_70299_a(index, stack);
                    ++index;
                }
                NetworkUtil.sendNetworkPacket(new PacketRecipeTransferUpdate(fabricator, craftingInventory), pos, player.field_70170_p);
            }
        }
    }
}

