/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.blocks;

import forestry.core.blocks.IBlockTypeTesr;
import forestry.core.blocks.IMachinePropertiesTesr;
import forestry.core.blocks.MachinePropertiesTesr;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileBase;
import forestry.core.tiles.TileMill;
import forestry.factory.tiles.TileBottler;
import forestry.factory.tiles.TileCarpenter;
import forestry.factory.tiles.TileCentrifuge;
import forestry.factory.tiles.TileFermenter;
import forestry.factory.tiles.TileMillRainmaker;
import forestry.factory.tiles.TileMoistener;
import forestry.factory.tiles.TileSqueezer;
import forestry.factory.tiles.TileStill;

public enum BlockTypeFactoryTesr implements IBlockTypeTesr
{
    BOTTLER(TileBottler.class, "bottler"),
    CARPENTER(TileCarpenter.class, "carpenter"),
    CENTRIFUGE(TileCentrifuge.class, "centrifuge"),
    FERMENTER(TileFermenter.class, "fermenter"),
    MOISTENER(TileMoistener.class, "moistener"),
    SQUEEZER(TileSqueezer.class, "squeezer"),
    STILL(TileStill.class, "still"),
    RAINMAKER(TileMillRainmaker.class, "rainmaker", "textures/blocks/rainmaker_");

    public static final BlockTypeFactoryTesr[] VALUES;
    private final IMachinePropertiesTesr<?> machineProperties;

    private <T extends TileBase> BlockTypeFactoryTesr(Class<T> teClass, String name) {
        MachinePropertiesTesr machineProperties = new MachinePropertiesTesr(teClass, name, "forestry:blocks/" + name + ".0");
        Proxies.render.setRenderDefaultMachine(machineProperties, "textures/blocks/" + name + "_");
        this.machineProperties = machineProperties;
    }

    private <T extends TileMill> BlockTypeFactoryTesr(Class<T> teClass, String name, String renderMillTexture) {
        MachinePropertiesTesr machineProperties = new MachinePropertiesTesr(teClass, name, "forestry:blocks/" + name + ".0");
        Proxies.render.setRenderMill(machineProperties, renderMillTexture);
        this.machineProperties = machineProperties;
    }

    public IMachinePropertiesTesr<?> getMachineProperties() {
        return this.machineProperties;
    }

    public String func_176610_l() {
        return this.getMachineProperties().func_176610_l();
    }

    static {
        VALUES = BlockTypeFactoryTesr.values();
    }
}

