/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitLayout;
import forestry.core.circuits.ContainerSolderingIron;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketGuiLayoutSelect
extends ForestryPacket
implements IForestryPacketClient {
    private final String layoutUid;

    public PacketGuiLayoutSelect(String layoutUid) {
        this.layoutUid = layoutUid;
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.GUI_LAYOUT_SELECT;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_180714_a(this.layoutUid);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) {
            String layoutUid = data.readString();
            Container container = player.field_71070_bA;
            if (!(container instanceof ContainerSolderingIron)) {
                return;
            }
            ICircuitLayout layout = ChipsetManager.circuitRegistry.getLayout(layoutUid);
            if (layout != null) {
                ((ContainerSolderingIron)container).setLayout(layout);
            }
        }
    }
}

