/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.multiblock.IMultiblockSizeLimits;
import forestry.core.multiblock.MultiblockControllerForestry;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.Translator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class RectangularMultiblockControllerBase
extends MultiblockControllerForestry {
    private final IMultiblockSizeLimits sizeLimits;

    protected RectangularMultiblockControllerBase(World world, IMultiblockSizeLimits sizeLimits) {
        super(world);
        this.sizeLimits = sizeLimits;
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        int minX = this.sizeLimits.getMinimumXSize();
        int minY = this.sizeLimits.getMinimumYSize();
        int minZ = this.sizeLimits.getMinimumZSize();
        if (this.connectedParts.size() < this.sizeLimits.getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small", minX, minY, minZ));
        }
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.func_177958_n() - minimumCoord.func_177958_n() + 1;
        int deltaY = maximumCoord.func_177956_o() - minimumCoord.func_177956_o() + 1;
        int deltaZ = maximumCoord.func_177952_p() - minimumCoord.func_177952_p() + 1;
        int maxX = this.sizeLimits.getMaximumXSize();
        int maxY = this.sizeLimits.getMaximumYSize();
        int maxZ = this.sizeLimits.getMaximumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.large.x", maxX));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.large.y", maxY));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.large.z", maxZ));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small.x", minX));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small.y", minY));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small.z", minZ));
        }
        Class<?> myClass = this.getClass();
        for (int x = minimumCoord.func_177958_n(); x <= maximumCoord.func_177958_n(); ++x) {
            for (int y = minimumCoord.func_177956_o(); y <= maximumCoord.func_177956_o(); ++y) {
                for (int z = minimumCoord.func_177952_p(); z <= maximumCoord.func_177952_p(); ++z) {
                    IMultiblockComponent part;
                    BlockPos pos = new BlockPos(x, y, z);
                    TileEntity te = TileUtil.getTile((IBlockAccess)this.world, pos);
                    if (te instanceof IMultiblockComponent) {
                        part = (IMultiblockComponent)te;
                        if (!myClass.equals(part.getMultiblockLogic().getController().getClass())) {
                            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.invalid.part", Translator.translateToLocal(this.getUnlocalizedType())));
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == minimumCoord.func_177958_n()) {
                        ++extremes;
                    }
                    if (y == minimumCoord.func_177956_o()) {
                        ++extremes;
                    }
                    if (z == minimumCoord.func_177952_p()) {
                        ++extremes;
                    }
                    if (x == maximumCoord.func_177958_n()) {
                        ++extremes;
                    }
                    if (y == maximumCoord.func_177956_o()) {
                        ++extremes;
                    }
                    if (z == maximumCoord.func_177952_p()) {
                        ++extremes;
                    }
                    if (extremes >= 1) {
                        int exteriorLevel = y - minimumCoord.func_177956_o();
                        if (part != null) {
                            this.isGoodForExteriorLevel(part, exteriorLevel);
                            continue;
                        }
                        this.isBlockGoodForExteriorLevel(exteriorLevel, this.world, pos);
                        continue;
                    }
                    if (part != null) {
                        this.isGoodForInterior(part);
                        continue;
                    }
                    this.isBlockGoodForInterior(this.world, pos);
                }
            }
        }
    }

    protected IMultiblockSizeLimits getSizeLimits() {
        return this.sizeLimits;
    }

    protected abstract void isGoodForExteriorLevel(IMultiblockComponent var1, int var2) throws MultiblockValidationException;

    protected abstract void isGoodForInterior(IMultiblockComponent var1) throws MultiblockValidationException;
}

