/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.gui.events.GuiEvent;
import forestry.core.gui.Drawable;
import forestry.core.gui.buttons.StandardButtonTextureSets;
import forestry.core.gui.elements.GuiElement;
import forestry.core.utils.SoundUtil;
import java.util.function.Consumer;
import net.minecraft.client.renderer.GlStateManager;

public class ButtonElement
extends GuiElement {
    private final Consumer<ButtonElement> onClicked;
    private final Drawable[] textures = new Drawable[3];
    private boolean enabled = true;

    public ButtonElement(int xPos, int yPos, int width, int height, Drawable disabledDrawable, Drawable enabledDrawable, Consumer<ButtonElement> onClicked) {
        this(xPos, yPos, width, height, disabledDrawable, enabledDrawable, enabledDrawable, onClicked);
    }

    public ButtonElement(int xPos, int yPos, int width, int height, Drawable disabledDrawable, Drawable enabledDrawable, Drawable mouseOverDrawable, Consumer<ButtonElement> onClicked) {
        super(xPos, yPos, width, height);
        this.onClicked = onClicked;
        this.textures[0] = disabledDrawable;
        this.textures[1] = enabledDrawable;
        this.textures[2] = mouseOverDrawable;
        this.addSelfEventHandler(GuiEvent.DownEvent.class, event -> {
            if (!this.enabled) {
                return;
            }
            this.onPressed();
            SoundUtil.playButtonClick();
        });
    }

    public ButtonElement(int xPos, int yPos, Drawable drawable, Consumer<ButtonElement> onClicked) {
        super(xPos, yPos, drawable.uWidth, drawable.vHeight);
        this.onClicked = onClicked;
        for (int i = 0; i < 3; ++i) {
            this.textures[i] = new Drawable(drawable.textureLocation, drawable.u, drawable.v + drawable.vHeight * i, drawable.uWidth, drawable.vHeight);
        }
        this.addSelfEventHandler(GuiEvent.DownEvent.class, event -> {
            if (!this.enabled) {
                return;
            }
            this.onPressed();
            SoundUtil.playButtonClick();
        });
    }

    public ButtonElement(int xPos, int yPos, StandardButtonTextureSets textureSets, Consumer<ButtonElement> onClicked) {
        super(xPos, yPos, textureSets.getWidth(), textureSets.getHeight());
        this.onClicked = onClicked;
        for (int i = 0; i < 3; ++i) {
            this.textures[i] = new Drawable(textureSets.getTexture(), textureSets.getX(), textureSets.getY() + textureSets.getHeight() * i, textureSets.getWidth(), textureSets.getHeight());
        }
        this.addSelfEventHandler(GuiEvent.DownEvent.class, event -> {
            if (!this.enabled) {
                return;
            }
            this.onPressed();
            SoundUtil.playButtonClick();
        });
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        GlStateManager.func_179141_d();
        boolean mouseOver = this.isMouseOver();
        int hoverState = this.getHoverState(mouseOver);
        Drawable drawable = this.textures[hoverState];
        drawable.draw(0, 0);
        GlStateManager.func_179118_c();
    }

    @Override
    public boolean canMouseOver() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected int getHoverState(boolean mouseOver) {
        int i = 1;
        if (!this.enabled) {
            i = 0;
        } else if (mouseOver) {
            i = 2;
        }
        return i;
    }

    public void onPressed() {
        this.onClicked.accept(this);
    }
}

