/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.core.utils.Translator;
import java.util.List;

public abstract class Circuit
implements ICircuit {
    private final String uid;

    protected Circuit(String uid) {
        this.uid = uid;
        ChipsetManager.circuitRegistry.registerCircuit(this);
    }

    @Override
    public String getUID() {
        return "forestry." + this.uid;
    }

    @Override
    public String getUnlocalizedName() {
        return "for.circuit." + this.uid;
    }

    @Override
    public void addTooltip(List<String> list) {
        String unlocalizedDescription;
        String description;
        list.add(this.getLocalizedName());
        int i = 1;
        while (!(description = Translator.translateToLocal(unlocalizedDescription = this.getUnlocalizedName() + ".description." + i)).endsWith(unlocalizedDescription)) {
            list.add(" - " + description);
            ++i;
        }
    }
}

