/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.blocks.BlockForestry;
import forestry.core.circuits.ISocketable;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.InventoryUtil;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockStructure
extends BlockForestry {
    protected long previousMessageTick = 0L;

    protected BlockStructure(Material material) {
        super(material);
        this.func_149711_c(1.0f);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        MultiblockTileEntityForestry part = TileUtil.getTile((IBlockAccess)worldIn, pos, MultiblockTileEntityForestry.class);
        if (part == null) {
            return false;
        }
        IMultiblockController controller = part.getMultiblockLogic().getController();
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            if (controller != null) {
                String validationError;
                if (!controller.isAssembled() && (validationError = controller.getLastValidationError()) != null) {
                    long tick = worldIn.func_82737_E();
                    if (tick > this.previousMessageTick + 20L) {
                        playerIn.func_145747_a((ITextComponent)new TextComponentString(validationError));
                        this.previousMessageTick = tick;
                    }
                    return true;
                }
            } else {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("for.multiblock.error.notConnected", new Object[0]));
                return true;
            }
        }
        if (controller == null || !controller.isAssembled()) {
            return false;
        }
        if (!worldIn.field_72995_K) {
            part.openGui(playerIn);
        }
        return true;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (placer instanceof EntityPlayer) {
            TileUtil.actOnTile((IBlockAccess)world, pos, MultiblockTileEntityForestry.class, tile -> {
                EntityPlayer player = (EntityPlayer)placer;
                GameProfile gameProfile = player.func_146103_bH();
                tile.setOwner(gameProfile);
            });
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        TileUtil.actOnTile((IBlockAccess)world, pos, IMultiblockComponent.class, tile -> {
            if (MultiblockUtil.getNeighboringParts(world, tile).isEmpty()) {
                if (tile instanceof IInventory) {
                    InventoryUtil.dropInventory((IInventory)tile, world, pos);
                }
                if (tile instanceof ISocketable) {
                    InventoryUtil.dropSockets((ISocketable)((Object)tile), world, pos);
                }
            }
        });
        super.func_180663_b(world, pos, state);
    }
}

