/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.genetics.IEffectData;
import forestry.core.genetics.alleles.AlleleCategorized;
import forestry.core.render.ParticleRender;
import forestry.core.utils.VectUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AlleleEffect
extends AlleleCategorized
implements IAlleleBeeEffect {
    protected AlleleEffect(String valueName, boolean isDominant) {
        super("forestry", "effect", valueName, isDominant);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        return storedData;
    }

    @Override
    public boolean isCombinable() {
        return false;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        return storedData;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        IBeekeepingLogic beekeepingLogic = housing.getBeekeepingLogic();
        List<BlockPos> flowerPositions = beekeepingLogic.getFlowerPositions();
        ParticleRender.addBeeHiveFX(housing, genome, flowerPositions);
        return storedData;
    }

    public static Vec3i getModifiedArea(IBeeGenome genome, IBeeHousing housing) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        float territoryModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        BlockPos area = VectUtil.scale(genome.getTerritory(), territoryModifier);
        int x = area.func_177958_n();
        int y = area.func_177956_o();
        int z = area.func_177952_p();
        if (x < 1) {
            x = 1;
        }
        if (y < 1) {
            y = 1;
        }
        if (z < 1) {
            z = 1;
        }
        return new Vec3i(x, y, z);
    }

    public static AxisAlignedBB getBounding(IBeeGenome genome, IBeeHousing housing) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        float territoryModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        BlockPos area = VectUtil.scale(genome.getTerritory(), territoryModifier);
        BlockPos offset = VectUtil.scale((Vec3i)area, -0.5f);
        BlockPos min = housing.getCoordinates().func_177971_a((Vec3i)offset);
        BlockPos max = min.func_177971_a((Vec3i)area);
        return new AxisAlignedBB((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p(), (double)max.func_177958_n(), (double)max.func_177956_o(), (double)max.func_177952_p());
    }

    public static <T extends Entity> List<T> getEntitiesInRange(IBeeGenome genome, IBeeHousing housing, Class<T> entityClass) {
        AxisAlignedBB boundingBox = AlleleEffect.getBounding(genome, housing);
        return housing.getWorldObj().func_72872_a(entityClass, boundingBox);
    }
}

