/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.world;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ExplosionBase
extends Explosion {
    public ExplosionBase(World world, Entity entity, double x, double y, double z, float size, boolean flaming, boolean damagesTerrain) {
        super(world, entity, x, y, z, size, flaming, damagesTerrain);
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.field_77284_b;
                    double d6 = this.field_77285_c;
                    double d8 = this.field_77282_d;
                    float f1 = 0.3f;
                    for (float f = this.field_77280_f * (0.7f + this.field_77287_j.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        IBlockState affectedState = this.field_77287_j.func_180495_p(blockpos);
                        if (affectedState.func_185904_a() != Material.field_151579_a) {
                            float f2 = this.field_77283_e != null ? this.field_77283_e.func_180428_a((Explosion)this, this.field_77287_j, blockpos, affectedState) : affectedState.func_177230_c().getExplosionResistance(this.field_77287_j, blockpos, (Entity)null, (Explosion)this);
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.field_77283_e == null || this.field_77283_e.func_174816_a((Explosion)this, this.field_77287_j, blockpos, affectedState, f))) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.field_77281_g.addAll(set);
        if (this.affectsEntities()) {
            float totalSize = this.field_77280_f * 2.0f;
            int xMin = MathHelper.func_76128_c((double)(this.field_77284_b - (double)totalSize - 1.0));
            int xMax = MathHelper.func_76128_c((double)(this.field_77284_b + (double)totalSize + 1.0));
            int yMin = MathHelper.func_76128_c((double)(this.field_77285_c - (double)totalSize - 1.0));
            int yMax = MathHelper.func_76128_c((double)(this.field_77285_c + (double)totalSize + 1.0));
            int zMin = MathHelper.func_76128_c((double)(this.field_77282_d - (double)totalSize - 1.0));
            int zMax = MathHelper.func_76128_c((double)(this.field_77282_d + (double)totalSize + 1.0));
            List entitiesInBlastzone = this.field_77287_j.func_72839_b(this.field_77283_e, new AxisAlignedBB((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax));
            ForgeEventFactory.onExplosionDetonate((World)this.field_77287_j, (Explosion)this, (List)entitiesInBlastzone, (double)totalSize);
            Vec3d explosionPosition = new Vec3d(this.field_77284_b, this.field_77285_c, this.field_77282_d);
            for (Entity entity : entitiesInBlastzone) {
                if (!this.canAffectEntity(entity)) continue;
                double distance = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)totalSize;
                this.affectEntity(entity, explosionPosition, distance, totalSize);
            }
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        this.playExplosionSound();
        this.spawnExplosionParticle();
        for (BlockPos blockpos : this.func_180343_e()) {
            IBlockState state = this.field_77287_j.func_180495_p(blockpos);
            Block block = state.func_177230_c();
            if (spawnParticles) {
                this.spawnBlockExplosionParticles(blockpos);
            }
            if (state.func_185904_a() != Material.field_151579_a) {
                this.destroyBlock(block, state, blockpos);
                continue;
            }
            if (!this.doesCauseFire() || this.field_77287_j.func_180495_p(blockpos).func_185904_a() != Material.field_151579_a || !this.field_77287_j.func_180495_p(blockpos.func_177977_b()).func_185913_b() || this.field_77290_i.nextInt(3) != 0) continue;
            this.field_77287_j.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public void destroyBlock(Block block, IBlockState state, BlockPos pos) {
        if (this.doesDestroyBlocks()) {
            if (block.func_149659_a((Explosion)this)) {
                block.func_180653_a(this.field_77287_j, pos, this.field_77287_j.func_180495_p(pos), 1.0f / this.field_77280_f, 0);
            }
            block.onBlockExploded(this.field_77287_j, pos, (Explosion)this);
        }
    }

    public void playExplosionSound() {
        this.field_77287_j.func_184148_a((EntityPlayer)null, this.field_77284_b, this.field_77285_c, this.field_77282_d, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    public void spawnExplosionParticle() {
        EnumParticleTypes particle = this.field_77280_f >= 2.0f && this.field_82755_b ? EnumParticleTypes.EXPLOSION_HUGE : EnumParticleTypes.EXPLOSION_LARGE;
        this.field_77287_j.func_175688_a(particle, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0, new int[0]);
    }

    public void spawnBlockExplosionParticles(BlockPos pos) {
        double particleX = (float)pos.func_177958_n() + this.field_77287_j.field_73012_v.nextFloat();
        double particleY = (float)pos.func_177956_o() + this.field_77287_j.field_73012_v.nextFloat();
        double particleZ = (float)pos.func_177952_p() + this.field_77287_j.field_73012_v.nextFloat();
        double velocityX = -this.field_77284_b;
        double velocityY = -this.field_77285_c;
        double velocityZ = -this.field_77282_d;
        double d6 = MathHelper.func_76133_a((double)(velocityX * velocityX + velocityY * velocityY + velocityZ * velocityZ));
        velocityX /= d6;
        velocityY /= d6;
        velocityZ /= d6;
        double d7 = 0.5 / (d6 / (double)this.field_77280_f + 0.1) * (double)(this.field_77287_j.field_73012_v.nextFloat() * this.field_77287_j.field_73012_v.nextFloat() + 0.3f);
        this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (particleX + this.field_77284_b) / 2.0, (particleY + this.field_77285_c) / 2.0, (particleZ + this.field_77282_d) / 2.0, velocityX *= d7, velocityY *= d7, velocityZ *= d7, new int[0]);
        this.field_77287_j.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, particleX, particleY, particleZ, velocityX, velocityY, velocityZ, new int[0]);
    }

    public boolean doesCauseFire() {
        return this.field_77286_a;
    }

    public boolean doesDestroyBlocks() {
        return this.field_82755_b;
    }

    public Random getRandom() {
        return this.field_77290_i;
    }

    public World getWorld() {
        return this.field_77287_j;
    }

    public float getSize() {
        return this.field_77280_f;
    }

    public double getX() {
        return this.field_77284_b;
    }

    public double getY() {
        return this.field_77285_c;
    }

    public double getZ() {
        return this.field_77282_d;
    }

    public boolean affectsEntities() {
        return true;
    }

    public boolean canAffectEntity(Entity entity) {
        return !entity.func_180427_aV();
    }

    public void affectEntity(Entity entity, Vec3d position, double distanceFrom, float size) {
        double d9;
        double d7;
        double d5;
        double d13;
        if (distanceFrom <= 1.0 && (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.field_77284_b) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.field_77285_c) * d7 + (d9 = entity.field_70161_v - this.field_77282_d) * d9))) != 0.0) {
            EntityPlayer entityplayer;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = this.field_77287_j.func_72842_a(position, entity.func_174813_aQ());
            double d10 = (1.0 - distanceFrom) * d14;
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)size + 1.0)));
            double d11 = d10;
            if (entity instanceof EntityLivingBase) {
                d11 = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10);
            }
            entity.field_70159_w += d5 * d11;
            entity.field_70181_x += d7 * d11;
            entity.field_70179_y += d9 * d11;
            if (!(!(entity instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity).func_175149_v() || entityplayer.func_184812_l_() && entityplayer.field_71075_bZ.field_75100_b)) {
                this.field_77288_k.put(entityplayer, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
            }
        }
    }
}

