/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import javax.annotation.Nonnull;
import net.darkhax.bookshelf.lib.Constants;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class RegistryUtils {
    private RegistryUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static Enchantment getEnchantment(String id) {
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(id));
    }

    public static String getRegistryId(@Nonnull IForgeRegistryEntry.Impl<?> registerable) {
        if (registerable.getRegistryName() == null || registerable.getRegistryName().toString().isEmpty()) {
            Constants.LOG.warn("Attempted to get ID for invalid registerable object. " + registerable.getClass().getName(), new Object[0]);
            return "";
        }
        return registerable.getRegistryName().toString();
    }
}

