/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.awt.Color;
import net.darkhax.bookshelf.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class CollectionUtils {
    public static double[] toDouble(float[] input) {
        double[] output = new double[input.length];
        for (int index = 0; index < input.length; ++index) {
            output[index] = input[index];
        }
        return output;
    }

    public static float[] toFloat(double[] input) {
        float[] output = new float[input.length];
        for (int index = 0; index < input.length; ++index) {
            output[index] = (float)input[index];
        }
        return output;
    }

    public static String[] toString(ResourceLocation[] input) {
        String[] output = new String[input.length];
        for (int index = 0; index < input.length; ++index) {
            output[index] = input[index].toString();
        }
        return output;
    }

    public static ResourceLocation[] toIdentifier(String[] input) {
        ResourceLocation[] output = new ResourceLocation[input.length];
        for (int index = 0; index < input.length; ++index) {
            output[index] = new ResourceLocation(input[index]);
        }
        return output;
    }

    public static ResourceLocation[] toIdentifier(Item[] input) {
        ResourceLocation[] output = new ResourceLocation[input.length];
        for (int index = 0; index < input.length; ++index) {
            output[index] = input[index].getRegistryName();
        }
        return output;
    }

    public static ResourceLocation[] toIdentifier(Block[] input) {
        ResourceLocation[] output = new ResourceLocation[input.length];
        for (int index = 0; index < input.length; ++index) {
            output[index] = input[index].getRegistryName();
        }
        return output;
    }

    public static Item[] toItem(ResourceLocation[] input) {
        Item[] output = new Item[input.length];
        for (int index = 0; index < input.length; ++index) {
            output[index] = (Item)ForgeRegistries.ITEMS.getValue(input[index]);
        }
        return output;
    }

    public static Block[] toBlock(ResourceLocation[] input) {
        Block[] output = new Block[input.length];
        for (int index = 0; index < input.length; ++index) {
            output[index] = (Block)ForgeRegistries.BLOCKS.getValue(input[index]);
        }
        return output;
    }

    public static String[] toString(ItemStack[] input) {
        String[] output = new String[input.length];
        for (int index = 0; index < input.length; ++index) {
            output[index] = StackUtils.writeStackToString(input[index]);
        }
        return output;
    }

    public static ItemStack[] toStack(String[] input) {
        ItemStack[] output = new ItemStack[input.length];
        for (int index = 0; index < input.length; ++index) {
            output[index] = StackUtils.createStackFromString(input[index]);
        }
        return output;
    }

    public static int[] toInt(Color input) {
        return new int[]{input.getRed(), input.getGreen(), input.getBlue()};
    }

    public static Color toColor(int[] input) {
        return input.length == 3 ? new Color(input[0], input[1], input[2]) : Color.BLACK;
    }

    public static int[] toInt(BlockPos input) {
        return new int[]{input.func_177958_n(), input.func_177956_o(), input.func_177952_p()};
    }

    public static BlockPos toPos(int[] input) {
        return input.length == 3 ? new BlockPos(input[0], input[1], input[2]) : BlockPos.field_177992_a;
    }
}

