/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.lib.WeightedSelector;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class WeightedSelectorRegistry<T extends IForgeRegistryEntry<T>>
extends WeightedSelector<T> {
    private final Map<ResourceLocation, T> REGISTRY = new HashMap<ResourceLocation, T>();

    public boolean addEntry(T value, int weight, String id) {
        value.setRegistryName(new ResourceLocation(id));
        return this.addEntry(value, weight);
    }

    public T getValue(ResourceLocation id) {
        return (T)((IForgeRegistryEntry)this.REGISTRY.get(id));
    }

    @Override
    public boolean addEntry(T value, int weight) {
        if (value.getRegistryName() == null) {
            Constants.LOG.noticableWarning(true, Arrays.asList("Attempted to register an item without setting it's ID! This is not allowed.", value.toString()));
            return false;
        }
        boolean added = super.addEntry(value, weight);
        if (added) {
            this.REGISTRY.put(value.getRegistryName(), value);
        }
        return added;
    }

    @Override
    public boolean removeEntry(WeightedSelector.WeightedEntry<T> entry) {
        boolean removed = super.removeEntry(entry);
        if (removed) {
            this.REGISTRY.remove(((IForgeRegistryEntry)entry.getEntry()).getRegistryName());
        }
        return removed;
    }
}

