/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Deprecated
public final class RecipeGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private RecipeGenerator() {
        throw new IllegalAccessError("Utility class");
    }

    public static void createShapedRecipe(ItemStack result, Object ... components) {
        int i;
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<String> pattern = new ArrayList<String>();
        HashMap<String, Map<String, Object>> inputMap = new HashMap<String, Map<String, Object>>();
        boolean isOreDict = false;
        Character curKey = null;
        for (i = 0; i < components.length && components[i] instanceof String; ++i) {
            pattern.add((String)components[i]);
        }
        while (i < components.length) {
            Object component = components[i];
            if (component instanceof Character) {
                if (curKey != null) {
                    throw new IllegalArgumentException("Provided two char keys in a row");
                }
                curKey = (Character)component;
            } else {
                if (curKey == null) {
                    throw new IllegalArgumentException("Providing object without a char key");
                }
                if (component instanceof String) {
                    isOreDict = true;
                }
                inputMap.put(Character.toString(curKey.charValue()), RecipeGenerator.serializeComponent(component));
                curKey = null;
            }
            ++i;
        }
        json.put("pattern", pattern);
        json.put("key", inputMap);
        json.put("type", isOreDict ? "forge:ore_shaped" : "minecraft:crafting_shaped");
        json.put("result", RecipeGenerator.serializeComponent(result));
        RecipeGenerator.createRecipeFile(json, RecipeGenerator.generateRecipeName(result, components));
    }

    public static void createShapelessRecipe(ItemStack result, Object ... components) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        boolean isOreDict = false;
        for (Object component : components) {
            if (component instanceof String) {
                isOreDict = true;
            }
            ingredients.add(RecipeGenerator.serializeComponent(component));
        }
        json.put("ingredients", ingredients);
        json.put("type", isOreDict ? "forge:ore_shapeless" : "minecraft:crafting_shapeless");
        json.put("result", RecipeGenerator.serializeComponent(result));
        RecipeGenerator.createRecipeFile(json, RecipeGenerator.generateRecipeName(result, components));
    }

    private static Map<String, Object> serializeComponent(Object component) {
        if (component instanceof Item) {
            return RecipeGenerator.serializeComponent(new ItemStack((Item)component));
        }
        if (component instanceof Block) {
            return RecipeGenerator.serializeComponent(new ItemStack((Block)component));
        }
        if (component instanceof ItemStack) {
            ItemStack stack = (ItemStack)component;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("item", stack.func_77973_b().getRegistryName().toString());
            if (stack.func_77973_b().func_77614_k() || stack.func_77952_i() != 0) {
                ret.put("data", stack.func_77952_i());
            }
            if (stack.func_190916_E() > 1) {
                ret.put("count", stack.func_190916_E());
            }
            if (stack.func_77942_o()) {
                throw new IllegalArgumentException("Too lazy to implement nbt support rn");
            }
            return ret;
        }
        if (component instanceof String) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("type", "forge:ore_dict");
            ret.put("ore", component);
            return ret;
        }
        throw new IllegalArgumentException("Could not serialize the unsupported type " + component.getClass().getName());
    }

    private static String generateRecipeName(ItemStack output, Object ... inputs) {
        String resultName = output.func_77973_b().getRegistryName().toString() + "_" + output.func_77960_j();
        String inputName = "";
        for (Object input : inputs) {
            if (input instanceof IForgeRegistryEntry.Impl) {
                inputName = inputName + "_" + ((IForgeRegistryEntry.Impl)input).getRegistryName().toString();
                continue;
            }
            if (input instanceof String) {
                inputName = inputName + "_" + (String)input;
                continue;
            }
            if (input instanceof Character) {
                inputName = inputName + "_" + input;
                continue;
            }
            if (input instanceof ItemStack) {
                inputName = inputName + "_" + ((ItemStack)input).func_77973_b().getRegistryName().toString();
                continue;
            }
            throw new IllegalArgumentException("Could not generate name for the unsupported type " + input.getClass().getName());
        }
        return resultName.toLowerCase().replace(":", "_") + "_" + UUID.nameUUIDFromBytes(inputName.toLowerCase().getBytes()).toString().replace("-", "_");
    }

    private static void createRecipeFile(Map<String, Object> json, String fileName) {
        File directory = new File("recipes/" + Loader.instance().activeModContainer().getModId());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File output = new File(directory, fileName + ".json");
        try (FileWriter writer = new FileWriter(output);){
            GSON.toJson(json, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

