/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.vecmath;

import com.enderio.core.common.vecmath.Matrix4d;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4d;

public class ViewFrustum {
    public static final int LTN = 0;
    public static final int LTF = 1;
    public static final int LBN = 2;
    public static final int LBF = 3;
    public static final int RTN = 4;
    public static final int RTF = 5;
    public static final int RBN = 6;
    public static final int RBF = 7;
    public static final int VERTEX_COUNT = 8;
    public static final int PLANE_COUNT = 6;
    private static final int TOP = 0;
    private static final int BOTTOM = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private static final int NEAR = 4;
    private static final int FAR = 5;
    private Vector4d[] vertices = new Vector4d[8];
    private Vector4d[] planes = new Vector4d[6];
    private Vector3d eye;
    private Vector3d min;
    private Vector3d max;

    public ViewFrustum() {
        int i;
        this.eye = new Vector3d();
        this.min = new Vector3d();
        this.max = new Vector3d();
        for (i = 0; i < 8; ++i) {
            this.vertices[i] = new Vector4d();
        }
        for (i = 0; i < 6; ++i) {
            this.planes[i] = new Vector4d();
        }
    }

    public ViewFrustum(ViewFrustum other) {
        int i;
        this.eye = new Vector3d(other.eye);
        this.min = new Vector3d(other.min);
        this.max = new Vector3d(other.max);
        for (i = 0; i < 8; ++i) {
            this.vertices[i] = new Vector4d(other.vertices[i]);
        }
        for (i = 0; i < 6; ++i) {
            this.planes[i] = new Vector4d(other.planes[i]);
        }
    }

    public boolean containsPoint(Vector3d point) {
        for (Vector4d plane : this.planes) {
            if (!(ViewFrustum.distanceFromPointToPlane(plane, point) < 0.0)) continue;
            return false;
        }
        return true;
    }

    private static double distanceFromPointToPlane(Vector4d plane, Vector3d point) {
        Vector4d newPoint = new Vector4d(point.x, point.y, point.z, 1.0);
        return plane.dot(newPoint);
    }

    public Vector4d getVertex(int index) {
        return this.vertices[index];
    }

    public Vector3d getEye() {
        return this.eye;
    }

    public Vector3d getMin() {
        return this.min;
    }

    public Vector3d getMax() {
        return this.max;
    }

    public Vector4d getLeftPlane() {
        return this.getPlane(2);
    }

    public Vector4d getRightPlane() {
        return this.getPlane(3);
    }

    public Vector4d getTopPlane() {
        return this.getPlane(0);
    }

    public Vector4d getBottomPlane() {
        return this.getPlane(1);
    }

    public Vector4d getNearPlane() {
        return this.getPlane(4);
    }

    public Vector4d getFarPlane() {
        return this.getPlane(5);
    }

    public void computeFrustum(Matrix4d ivm, Matrix4d ipm) {
        Matrix4d vpm = new Matrix4d();
        vpm.mul(ivm, ipm);
        ivm.getTranslation(this.eye);
        this.vertices[3].set(-1.0, -1.0, 1.0, 1.0);
        this.vertices[1].set(-1.0, 1.0, 1.0, 1.0);
        this.vertices[5].set(1.0, 1.0, 1.0, 1.0);
        this.vertices[7].set(1.0, -1.0, 1.0, 1.0);
        this.vertices[2].set(-1.0, -1.0, -1.0, 1.0);
        this.vertices[0].set(-1.0, 1.0, -1.0, 1.0);
        this.vertices[4].set(1.0, 1.0, -1.0, 1.0);
        this.vertices[6].set(1.0, -1.0, -1.0, 1.0);
        this.min.set(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.max.set(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (int i = 0; i < 8; ++i) {
            vpm.transform(this.vertices[i]);
            double w = this.vertices[i].w;
            this.vertices[i].x /= w;
            this.vertices[i].y /= w;
            this.vertices[i].z /= w;
            this.min.x = Math.min(this.min.x, this.vertices[i].x);
            this.min.y = Math.min(this.min.y, this.vertices[i].y);
            this.min.z = Math.min(this.min.z, this.vertices[i].z);
            this.max.x = Math.max(this.max.x, this.vertices[i].x);
            this.max.y = Math.max(this.max.y, this.vertices[i].y);
            this.max.z = Math.max(this.max.z, this.vertices[i].z);
        }
        VecmathUtil.computePlaneEquation(this.vertices[2], this.vertices[3], this.vertices[1], this.planes[2]);
        VecmathUtil.computePlaneEquation(this.vertices[2], this.vertices[3], this.vertices[1], this.planes[2]);
        VecmathUtil.computePlaneEquation(this.vertices[6], this.vertices[5], this.vertices[7], this.planes[3]);
        VecmathUtil.computePlaneEquation(this.vertices[0], this.vertices[1], this.vertices[5], this.planes[0]);
        VecmathUtil.computePlaneEquation(this.vertices[2], this.vertices[7], this.vertices[3], this.planes[1]);
        VecmathUtil.computePlaneEquation(this.vertices[2], this.vertices[0], this.vertices[4], this.planes[4]);
        VecmathUtil.computePlaneEquation(this.vertices[3], this.vertices[5], this.vertices[1], this.planes[5]);
    }

    private final Vector4d getPlane(int index) {
        assert (index >= 0 && index < 6) : "Illegal index : 0 <= index < 6";
        return this.planes[index];
    }
}

