/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.fluid;

import com.enderio.core.common.fluid.IFluidWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CapabilityFluidWrapper
implements IFluidWrapper {
    private final IFluidHandler fluidHandler;

    public CapabilityFluidWrapper(IFluidHandler fluidHandler) {
        this.fluidHandler = fluidHandler;
    }

    @Override
    public int offer(FluidStack resource) {
        return this.fluidHandler.fill(resource, false);
    }

    @Override
    public int fill(FluidStack resource) {
        return this.fluidHandler.fill(resource, true);
    }

    @Override
    @Nullable
    public FluidStack drain(FluidStack resource) {
        return this.fluidHandler.drain(resource, true);
    }

    @Override
    @Nullable
    public FluidStack getAvailableFluid() {
        return this.fluidHandler.drain(Integer.MAX_VALUE, false);
    }

    @Override
    @Nonnull
    public List<IFluidWrapper.ITankInfoWrapper> getTankInfoWrappers() {
        ArrayList<IFluidWrapper.ITankInfoWrapper> result = new ArrayList<IFluidWrapper.ITankInfoWrapper>();
        IFluidTankProperties[] tankProperties = this.fluidHandler.getTankProperties();
        if (tankProperties != null) {
            for (IFluidTankProperties iFluidTankProperties : tankProperties) {
                if (iFluidTankProperties == null) continue;
                result.add(new InfoWrapper(iFluidTankProperties));
            }
        }
        return result;
    }

    private static class InfoWrapper
    implements IFluidWrapper.ITankInfoWrapper {
        private final IFluidTankProperties prop;

        InfoWrapper(IFluidTankProperties prop) {
            this.prop = prop;
        }

        @Override
        public IFluidTankProperties getIFluidTankProperties() {
            return this.prop;
        }

        @Override
        public FluidTankInfo getFluidTankInfo() {
            return new FluidTankInfo(this.prop.getContents(), this.prop.getCapacity());
        }
    }
}

