/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.konwboy.tumbleweed.common.TumbleweedConfig;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector4f;

public class EntityTumbleweed
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int FADE_TIME = 80;
    private static final int DESPAWN_RANGE = 110;
    private static final float BASE_SIZE = 0.75f;
    private static final double WIND_X = -0.0625;
    private static final double WIND_Z = -0.0625;
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(EntityTumbleweed.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CUSTOM_WIND_ENABLED = EntityDataManager.func_187226_a(EntityTumbleweed.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> CUSTOM_WIND_X = EntityDataManager.func_187226_a(EntityTumbleweed.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> CUSTOM_WIND_Z = EntityDataManager.func_187226_a(EntityTumbleweed.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> FADING = EntityDataManager.func_187226_a(EntityTumbleweed.class, (DataSerializer)DataSerializers.field_187198_h);
    private int age;
    public int fadeAge;
    public boolean persistent;
    private double windMod;
    private int lifetime;
    private float angularX;
    private float angularZ;
    public float stretch = 1.0f;
    public float prevStretch = 1.0f;
    private boolean prevOnGround;
    private double prevMotionX;
    private double prevMotionY;
    private double prevMotionZ;
    @SideOnly(value=Side.CLIENT)
    public float rot1;
    @SideOnly(value=Side.CLIENT)
    public float rot2;
    @SideOnly(value=Side.CLIENT)
    public float rot3;
    @SideOnly(value=Side.CLIENT)
    public Quaternion quat;
    @SideOnly(value=Side.CLIENT)
    public Quaternion prevQuat;
    private static Field trackedEntityHashTable = EntityTumbleweed.fieldsOfType(EntityTracker.class, IntHashMap.class)[0];
    private static Field encodedPosX;
    private static Field encodedPosY;
    private static Field encodedPosZ;

    public EntityTumbleweed(World world) {
        super(world);
        this.field_70144_Y = 0.95f;
        this.field_70156_m = true;
        this.func_145769_d(this.func_145782_y());
        if (this.field_70170_p.field_72995_K) {
            this.initClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void initClient() {
        this.rot1 = 360.0f * this.field_70170_p.field_73012_v.nextFloat();
        this.rot2 = 360.0f * this.field_70170_p.field_73012_v.nextFloat();
        this.rot3 = 360.0f * this.field_70170_p.field_73012_v.nextFloat();
        this.quat = new Quaternion();
        this.prevQuat = new Quaternion();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SIZE, (Object)2);
        this.field_70180_af.func_187214_a(CUSTOM_WIND_ENABLED, (Object)false);
        this.field_70180_af.func_187214_a(CUSTOM_WIND_X, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CUSTOM_WIND_Z, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FADING, (Object)false);
        this.updateSize();
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("Size", this.getSize());
        nbt.func_74757_a("CustomWindEnabled", this.getCustomWindEnabled());
        nbt.func_74780_a("CustomWindX", this.getCustomWindX());
        nbt.func_74780_a("CustomWindZ", this.getCustomWindZ());
        nbt.func_74757_a("Persistent", this.persistent);
        AxisAlignedBB bb = this.func_174813_aQ();
        nbt.func_74782_a("AABB", (NBTBase)this.func_70087_a(new double[]{bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f}));
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Size")) {
            this.field_70180_af.func_187227_b(SIZE, (Object)nbt.func_74762_e("Size"));
        }
        this.field_70180_af.func_187227_b(CUSTOM_WIND_ENABLED, (Object)nbt.func_74767_n("CustomWindEnabled"));
        this.field_70180_af.func_187227_b(CUSTOM_WIND_X, (Object)Float.valueOf(nbt.func_74760_g("CustomWindX")));
        this.field_70180_af.func_187227_b(CUSTOM_WIND_Z, (Object)Float.valueOf(nbt.func_74760_g("CustomWindZ")));
        this.persistent = nbt.func_74767_n("Persistent");
        if (nbt.func_74764_b("AABB")) {
            NBTTagList aabb = nbt.func_150295_c("AABB", 6);
            this.func_174826_a(new AxisAlignedBB(aabb.func_150309_d(0), aabb.func_150309_d(1), aabb.func_150309_d(2), aabb.func_150309_d(3), aabb.func_150309_d(4), aabb.func_150309_d(5)));
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key.equals(SIZE)) {
            this.updateSize();
        }
    }

    private void updateSize() {
        float mcSize = 0.75f + (float)this.getSize() * 0.125f;
        if (this.field_70170_p.field_72995_K) {
            mcSize -= 4.8828125E-4f;
        }
        this.func_70105_a(mcSize, mcSize);
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_145769_d(int id) {
        super.func_145769_d(id);
        Random rand = new Random(id);
        this.windMod = 1.05 - 0.1 * rand.nextDouble();
        this.lifetime = 2400 + rand.nextInt(200);
    }

    public void func_70071_h_() {
        double windZ;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.trackerHack();
        }
        if (this.field_70170_p.field_72995_K) {
            this.preTickClient();
        }
        if (this.func_184187_bx() != null) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            return;
        }
        if (!this.func_70090_H()) {
            this.field_70181_x -= 0.012;
        }
        this.prevMotionX = this.field_70159_w;
        this.prevMotionY = this.field_70181_x;
        this.prevMotionZ = this.field_70179_y;
        this.prevOnGround = this.field_70122_E;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        double windX = this.getCustomWindEnabled() ? this.getCustomWindX() : -0.0625 * this.windMod;
        double d = windZ = this.getCustomWindEnabled() ? this.getCustomWindZ() : -0.0625 * this.windMod;
        if (this.func_70090_H()) {
            this.field_70181_x += 0.02;
            this.field_70159_w *= 0.95;
            this.field_70179_y *= 0.95;
            windZ = 0.0;
            windX = 0.0;
        } else if (windX != 0.0 || windZ != 0.0) {
            this.field_70159_w = windX;
            this.field_70179_y = windZ;
        }
        if (this.field_70170_p.field_72995_K) {
            this.tickClient();
        }
        if (this.field_70122_E) {
            this.field_70181_x = windX * windX + windZ * windZ >= 0.0025000000000000005 ? Math.max(-this.prevMotionY * 0.7, 0.24 - (double)this.getSize() * 0.02) : -this.prevMotionY * 0.7;
        }
        this.field_70159_w *= 0.98;
        this.field_70181_x *= 0.98;
        this.field_70179_y *= 0.98;
        this.collideWithNearbyEntities();
        if (!this.field_70170_p.field_72995_K) {
            this.age += this.field_70123_F || this.func_70090_H() ? 8 : 1;
            this.tryDespawn();
        }
        if (this.isFading()) {
            ++this.fadeAge;
            if (this.fadeAge > 80) {
                this.func_70106_y();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void preTickClient() {
        this.prevStretch = this.stretch;
        this.stretch *= 1.2f;
        if (this.stretch > 1.0f) {
            this.stretch = 1.0f;
        }
        this.prevQuat = new Quaternion((ReadableVector4f)this.quat);
    }

    @SideOnly(value=Side.CLIENT)
    private void tickClient() {
        if (this.prevOnGround != this.field_70122_E) {
            this.stretch *= 0.75f;
        }
        float motionAngleX = (float)(-this.prevMotionX) / (this.field_70130_N * 0.5f);
        float motionAngleZ = (float)this.prevMotionZ / (this.field_70130_N * 0.5f);
        if (this.field_70122_E) {
            this.angularX = motionAngleX;
            this.angularZ = motionAngleZ;
        }
        if (this.func_70090_H()) {
            this.angularX += motionAngleX * 0.2f;
            this.angularZ += motionAngleZ * 0.2f;
        }
        float resistance = this.func_70090_H() ? 0.9f : 0.96f;
        this.angularX *= resistance;
        this.angularZ *= resistance;
        Quaternion temp = new Quaternion();
        temp.setFromAxisAngle(new Vector4f(1.0f, 0.0f, 0.0f, this.angularZ));
        Quaternion.mul((Quaternion)temp, (Quaternion)this.quat, (Quaternion)this.quat);
        temp.setFromAxisAngle(new Vector4f(0.0f, 0.0f, 1.0f, this.angularX));
        Quaternion.mul((Quaternion)temp, (Quaternion)this.quat, (Quaternion)this.quat);
    }

    private void trackerHack() {
        EntityTrackerEntry entry = this.getTrackerEntry();
        if (entry != null && entry.field_73136_m == 0) {
            entry.field_73136_m += 30;
        }
    }

    private void tryDespawn() {
        if (this.persistent) {
            this.age = 0;
            return;
        }
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, -1.0);
        if (player != null && player.func_70068_e((Entity)this) > 12100.0) {
            this.func_70106_y();
        }
        if (this.age > this.lifetime && this.fadeAge == 0) {
            this.field_70180_af.func_187227_b(FADING, (Object)true);
        }
    }

    public boolean func_70112_a(double distance) {
        return distance < 16384.0;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            SoundType sound = SoundType.field_185850_c;
            this.func_184185_a(sound.func_185845_c(), (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
            if (TumbleweedConfig.enableDrops) {
                this.dropItem();
            }
        }
        return true;
    }

    private void dropItem() {
        ItemStack item = TumbleweedConfig.Logic.getRandomItem();
        if (item != null) {
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, item);
            entityitem.field_70159_w = 0.0;
            entityitem.field_70181_x = 0.2;
            entityitem.field_70179_y = 0.0;
            entityitem.func_174869_p();
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
    }

    public boolean func_85031_j(Entity entityIn) {
        return entityIn instanceof EntityPlayer && this.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)entityIn)), 0.0f);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187579_bV, 0.15f, 1.0f);
    }

    public boolean canTrample(World world, Block block, BlockPos pos, float fallDistance) {
        return world.field_73012_v.nextFloat() < 0.7f && world.func_82736_K().func_82766_b("mobGriefing") && TumbleweedConfig.damageCrops;
    }

    protected boolean func_142008_O() {
        return false;
    }

    private void collideWithNearbyEntities() {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(0.2, 0.0, 0.2), Entity::func_70104_M);
        for (Entity entity : list) {
            if (!this.field_70170_p.field_72995_K && entity instanceof EntityMinecart && ((EntityMinecart)entity).func_184264_v() == EntityMinecart.Type.RIDEABLE && entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y > 0.01 && entity.func_184188_bt().isEmpty() && this.func_184187_bx() == null) {
                this.func_184220_m(entity);
                this.field_70181_x += 0.25;
                this.field_70133_I = true;
            }
            entity.func_70108_f((Entity)this);
        }
    }

    public boolean isNotColliding() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    public void setSize(int size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)size);
    }

    public int getSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    public double getCustomWindX() {
        return ((Float)this.field_70180_af.func_187225_a(CUSTOM_WIND_X)).floatValue();
    }

    public double getCustomWindZ() {
        return ((Float)this.field_70180_af.func_187225_a(CUSTOM_WIND_Z)).floatValue();
    }

    public boolean getCustomWindEnabled() {
        return (Boolean)this.field_70180_af.func_187225_a(CUSTOM_WIND_ENABLED);
    }

    public boolean isFading() {
        return (Boolean)this.field_70180_af.func_187225_a(FADING);
    }

    private static Field[] fieldsOfType(Class inClass, Class type) {
        return (Field[])Arrays.stream(inClass.getDeclaredFields()).filter(f -> f.getType() == type).toArray(Field[]::new);
    }

    public EntityTrackerEntry getTrackerEntry() {
        EntityTrackerEntry entry = null;
        try {
            entry = (EntityTrackerEntry)((IntHashMap)trackedEntityHashTable.get(((WorldServer)this.field_70170_p).func_73039_n())).func_76041_a(this.func_145782_y());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return entry;
    }

    public void writeSpawnData(ByteBuf buffer) {
        EntityTrackerEntry entry = this.getTrackerEntry();
        try {
            buffer.writeLong(((Long)encodedPosX.get(entry)).longValue());
            buffer.writeLong(((Long)encodedPosY.get(entry)).longValue());
            buffer.writeLong(((Long)encodedPosZ.get(entry)).longValue());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.field_70118_ct = additionalData.readLong();
        this.field_70117_cu = additionalData.readLong();
        this.field_70116_cv = additionalData.readLong();
    }

    static {
        trackedEntityHashTable.setAccessible(true);
        encodedPosX = EntityTumbleweed.fieldsOfType(EntityTrackerEntry.class, Long.TYPE)[0];
        encodedPosX.setAccessible(true);
        encodedPosY = EntityTumbleweed.fieldsOfType(EntityTrackerEntry.class, Long.TYPE)[1];
        encodedPosY.setAccessible(true);
        encodedPosZ = EntityTumbleweed.fieldsOfType(EntityTrackerEntry.class, Long.TYPE)[2];
        encodedPosZ.setAccessible(true);
    }
}

