/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.factory.recipes.CarpenterRecipeManager;
import forestry.factory.recipes.CentrifugeRecipe;
import forestry.factory.recipes.CentrifugeRecipeManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import wanion.lib.common.MetaItem;
import wanion.lib.common.Util;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.resource.UniResourceContainer;

final class ForestryIntegration
extends AbstractIntegrationThread {
    private Set<ICarpenterRecipe> carpenterRecipes = (Set)Util.getField(CarpenterRecipeManager.class, (String)"recipes", null, Set.class);

    ForestryIntegration() {
        super("Forestry");
    }

    public String call() {
        try {
            this.removeBadCarpenterOutputs(this.carpenterRecipes);
            this.fixCentrifugeRecipes();
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
        }
        return this.threadName + "All these bees... they can hurt, you know?";
    }

    private void removeBadCarpenterOutputs(@Nonnull Set<ICarpenterRecipe> carpenterRecipes) {
        carpenterRecipes.removeIf(carpenterRecipe -> carpenterRecipe != null && this.resourceHandler.exists(MetaItem.get((ItemStack)carpenterRecipe.getCraftingGridRecipe().getOutput())));
    }

    private void bronzeThings(@Nonnull UniResourceContainer ingotBronze) {
    }

    private void fixCentrifugeRecipes() {
        Set centrifugeRecipes = (Set)Util.getField(CentrifugeRecipeManager.class, (String)"recipes", null, Set.class);
        if (centrifugeRecipes == null) {
            return;
        }
        ArrayList<CentrifugeRecipe> newRecipes = new ArrayList<CentrifugeRecipe>();
        Iterator centrifugeRecipeIterator = centrifugeRecipes.iterator();
        while (centrifugeRecipeIterator.hasNext()) {
            ICentrifugeRecipe centrifugeRecipe = (ICentrifugeRecipe)centrifugeRecipeIterator.next();
            newRecipes.add(new CentrifugeRecipe(centrifugeRecipe.getProcessingTime(), centrifugeRecipe.getInput(), this.correctCentrifugeOutput(centrifugeRecipe.getAllProducts())));
            centrifugeRecipeIterator.remove();
        }
        centrifugeRecipes.addAll(newRecipes);
    }

    @Nonnull
    private Map<ItemStack, Float> correctCentrifugeOutput(@Nonnull Map<ItemStack, Float> outputMap) {
        return outputMap.entrySet().stream().collect(Collectors.toMap(entry -> this.resourceHandler.getMainItemStack((ItemStack)entry.getKey()), Map.Entry::getValue));
    }
}

