/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import com.google.common.collect.Lists;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import wanion.lib.recipe.IRecipeResearcher;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.integration.IC2CIntegration;
import wanion.unidict.recipe.AbstractRecipeResearcher;
import wanion.unidict.recipe.ForgeRecipeResearcher;
import wanion.unidict.recipe.IC2CRecipeResearcher;
import wanion.unidict.recipe.IC2RecipeResearcher;
import wanion.unidict.recipe.VanillaRecipeResearcher;
import wanion.unidict.resource.UniResourceContainer;

public final class CraftingIntegration
extends AbstractIntegrationThread {
    private final Set<Map.Entry<ResourceLocation, IRecipe>> recipes = RegistryManager.ACTIVE.getRegistry(GameData.RECIPES).getEntries();
    private final Map<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>> shapedResearcherMap = new IdentityHashMap<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>>();
    private final Map<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>> shapelessResearcherMap = new IdentityHashMap<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>>();
    private final Map<UniResourceContainer, TIntObjectMap<List<IRecipe>>> smartRecipeMap = new IdentityHashMap<UniResourceContainer, TIntObjectMap<List<IRecipe>>>();
    private final Method getShapedRecipeKeyMethod;
    private final Method getShapelessRecipeKeyMethod;
    private final Method getNewShapedRecipeMethod;
    private final Method getNewShapedFromShapelessRecipeMethod;
    private final Method getNewShapelessRecipeMethod;
    private final Method getNewShapelessFromShapedRecipeMethod;
    private int totalRecipesReCreated = 0;

    public CraftingIntegration() {
        super("Crafting");
        ArrayList<AbstractRecipeResearcher> researcherList = new ArrayList<AbstractRecipeResearcher>();
        researcherList.add(new VanillaRecipeResearcher());
        researcherList.add(new ForgeRecipeResearcher());
        if (Loader.isModLoaded((String)"ic2") && !Loader.isModLoaded((String)"ic2-classic-spmod")) {
            researcherList.add(new IC2RecipeResearcher());
        }
        if (Loader.isModLoaded((String)"ic2-classic-spmod")) {
            researcherList.add(new IC2CRecipeResearcher());
        }
        researcherList.forEach(researcher -> {
            researcher.getShapedRecipeClasses().forEach(shapedRecipeClass -> this.shapedResearcherMap.put((Class<? extends IRecipe>)shapedRecipeClass, (IRecipeResearcher<? extends IRecipe, ? extends IRecipe>)researcher));
            researcher.getShapelessRecipeClasses().forEach(shapelessRecipeClass -> this.shapelessResearcherMap.put((Class<? extends IRecipe>)shapelessRecipeClass, (IRecipeResearcher<? extends IRecipe, ? extends IRecipe>)researcher));
        });
        try {
            this.getShapedRecipeKeyMethod = IRecipeResearcher.class.getMethod("getShapedRecipeKey", IRecipe.class);
            this.getShapelessRecipeKeyMethod = IRecipeResearcher.class.getMethod("getShapelessRecipeKey", IRecipe.class);
            this.getNewShapedRecipeMethod = IRecipeResearcher.class.getMethod("getNewShapedRecipe", IRecipe.class);
            this.getNewShapedFromShapelessRecipeMethod = IRecipeResearcher.class.getMethod("getNewShapedFromShapelessRecipe", IRecipe.class);
            this.getNewShapelessRecipeMethod = IRecipeResearcher.class.getMethod("getNewShapelessRecipe", IRecipe.class);
            this.getNewShapelessFromShapedRecipeMethod = IRecipeResearcher.class.getMethod("getNewShapelessFromShapedRecipe", IRecipe.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Couldn't find the Methods!");
        }
    }

    public String call() {
        try {
            this.doTheResearch();
            this.reCreateTheRecipes();
            if (Loader.isModLoaded((String)"ic2-classic-spmod")) {
                IC2CIntegration.fixAdvancedRecipes(this.resourceHandler);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(this.threadName + e);
        }
        return this.threadName + "Why so many recipes? I had to deal with at least " + this.totalRecipesReCreated + " recipes.";
    }

    private void doTheResearch() {
        ArrayList<ResourceLocation> recipesToRemove = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, IRecipe> entry : this.recipes) {
            UniResourceContainer bufferContainer;
            IRecipe recipe = entry.getValue();
            boolean isShapeless = false;
            if (this.config.recipesToIgnore.contains(entry.getKey()) || this.config.ignoreModIdRecipes.contains(entry.getKey().func_110624_b()) || recipe == null || recipe.func_77571_b() == ItemStack.field_190927_a || (bufferContainer = this.resourceHandler.getContainer(entry.getValue().func_77571_b())) == null || !this.shapedResearcherMap.containsKey(recipe.getClass()) && !(isShapeless = this.shapelessResearcherMap.containsKey(recipe.getClass()))) continue;
            try {
                TIntObjectHashMap evenSmarterRecipeMap;
                int recipeKey = !isShapeless ? ((Integer)this.getShapedRecipeKeyMethod.invoke(this.shapedResearcherMap.get(recipe.getClass()), recipe)).intValue() : ((Integer)this.getShapelessRecipeKeyMethod.invoke(this.shapelessResearcherMap.get(recipe.getClass()), recipe)).intValue();
                if (recipeKey == 0) continue;
                if (!this.smartRecipeMap.containsKey(bufferContainer)) {
                    evenSmarterRecipeMap = new TIntObjectHashMap();
                    this.smartRecipeMap.put(bufferContainer, (TIntObjectMap<List<IRecipe>>)evenSmarterRecipeMap);
                } else {
                    evenSmarterRecipeMap = this.smartRecipeMap.get(bufferContainer);
                }
                if (!evenSmarterRecipeMap.containsKey(recipeKey)) {
                    evenSmarterRecipeMap.put(recipeKey, (Object)Lists.newArrayList((Object[])new IRecipe[]{recipe}));
                } else {
                    ((List)evenSmarterRecipeMap.get(recipeKey)).add(recipe);
                }
                recipesToRemove.add(recipe.getRegistryName());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        ForgeRegistry recipeRegistry = RegistryManager.ACTIVE.getRegistry(GameData.RECIPES);
        recipesToRemove.forEach(arg_0 -> ((ForgeRegistry)recipeRegistry).remove(arg_0));
    }

    private void reCreateTheRecipes() {
        HashMap comparatorCache = new HashMap();
        this.smartRecipeMap.forEach((container, evenSmartRecipeMap) -> evenSmartRecipeMap.forEachValue(recipeList -> {
            IRecipe recipe;
            boolean isShapeless;
            if (recipeList.size() > 1) {
                Comparator<IRecipe> recipeComparator;
                boolean hasComparator = comparatorCache.containsKey(container);
                Comparator<IRecipe> comparator = recipeComparator = hasComparator ? (Comparator)comparatorCache.get(container) : new RecipeComparator(container.getComparator());
                if (!hasComparator) {
                    comparatorCache.put(container, recipeComparator);
                }
                recipeList.sort(recipeComparator);
            }
            IRecipeResearcher<? extends IRecipe, ? extends IRecipe> recipeResearcher = !(isShapeless = this.shapelessResearcherMap.containsKey((recipe = (IRecipe)recipeList.get(0)).getClass())) ? this.shapedResearcherMap.get(recipe.getClass()) : this.shapelessResearcherMap.get(recipe.getClass());
            try {
                IRecipe iRecipe;
                if (recipe.func_192400_c().size() == 9) {
                    iRecipe = isShapeless ? (IRecipe)this.getNewShapedFromShapelessRecipeMethod.invoke(recipeResearcher, recipe) : (IRecipe)this.getNewShapedRecipeMethod.invoke(recipeResearcher, recipe);
                } else if (recipe.func_192400_c().size() == 1) {
                    iRecipe = isShapeless ? (IRecipe)this.getNewShapelessRecipeMethod.invoke(recipeResearcher, recipe) : (IRecipe)this.getNewShapelessFromShapedRecipeMethod.invoke(recipeResearcher, recipe);
                } else {
                    IRecipe iRecipe2 = iRecipe = isShapeless ? (IRecipe)this.getNewShapelessRecipeMethod.invoke(recipeResearcher, recipe) : (IRecipe)this.getNewShapedRecipeMethod.invoke(recipeResearcher, recipe);
                }
                if (iRecipe != null) {
                    ForgeRegistries.RECIPES.register((IForgeRegistryEntry)iRecipe.setRegistryName(new ResourceLocation(iRecipe.func_193358_e())));
                    ++this.totalRecipesReCreated;
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.logger.error("Crafting Integration: Couldn't create the recipe for " + recipe.func_77571_b().func_82833_r() + ".\nfor now, isn't possible to restore the original recipe.");
                e.printStackTrace();
            }
            return true;
        }));
    }

    private static class RecipeComparator
    implements Comparator<IRecipe> {
        private final Comparator<ItemStack> itemStackComparator;

        private RecipeComparator(@Nonnull Comparator<ItemStack> itemStackComparator) {
            this.itemStackComparator = itemStackComparator;
        }

        @Override
        public int compare(IRecipe o1, IRecipe o2) {
            return this.itemStackComparator.compare(o1.func_77571_b(), o2.func_77571_b());
        }
    }
}

