/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.common;

import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import wanion.lib.common.MetaItem;
import wanion.unidict.Config;
import wanion.unidict.UniDict;
import wanion.unidict.resource.Resource;
import wanion.unidict.resource.ResourceHandler;

public final class Util {
    public static final Comparator<ItemStack> itemStackComparatorByModName = new Comparator<ItemStack>(){

        @Override
        public int compare(@Nonnull ItemStack itemStack1, @Nonnull ItemStack itemStack2) {
            int stackIndex2;
            int stackIndex1;
            boolean sameIndexModAndItem;
            String stack1ModName = wanion.lib.common.Util.getModName((ItemStack)itemStack1);
            String stack2ModName = wanion.lib.common.Util.getModName((ItemStack)itemStack2);
            Config config = UniDict.getConfig();
            if (config.keepOneEntry && config.keepOneEntryModBlackSet.contains(stack1ModName)) {
                ResourceHandler.addToKeepOneEntryModBlackSet(itemStack1);
            }
            boolean bl = sameIndexModAndItem = (stackIndex1 = this.getIndex(stack1ModName)) == (stackIndex2 = this.getIndex(stack2ModName)) && stack1ModName.equals(stack2ModName) && itemStack1.func_77973_b() == itemStack2.func_77973_b();
            return !sameIndexModAndItem ? (stackIndex1 < stackIndex2 ? -1 : 0) : (itemStack1.func_77952_i() < itemStack2.func_77952_i() ? -1 : 0);
        }

        private int getIndex(String modName) {
            return UniDict.getConfig().ownerOfEveryThing.get((Object)modName);
        }
    };

    private Util() {
    }

    public static int getCumulative(@Nonnull Object[] objects, @Nonnull ResourceHandler resourceHandler) {
        int cumulativeKey = 0;
        for (Object object : objects) {
            if (object instanceof ItemStack) {
                cumulativeKey += MetaItem.get((ItemStack)resourceHandler.getMainItemStack((ItemStack)object));
                continue;
            }
            if (!(object instanceof List) || ((List)object).isEmpty()) continue;
            cumulativeKey += MetaItem.get((ItemStack)((ItemStack)((List)object).get(0)));
        }
        return cumulativeKey;
    }

    public static TIntList getList(@Nonnull Object[] objects, @Nonnull ResourceHandler resourceHandler) {
        TIntArrayList keys = new TIntArrayList();
        for (Object object : objects) {
            int bufKey;
            if (object instanceof ItemStack) {
                bufKey = MetaItem.get((ItemStack)resourceHandler.getMainItemStack((ItemStack)object));
                if (bufKey <= 0) continue;
                keys.add(bufKey);
                continue;
            }
            if (object instanceof Ingredient && ((Ingredient)object).func_193365_a().length > 0) {
                bufKey = MetaItem.get((ItemStack)resourceHandler.getMainItemStack(((Ingredient)object).func_193365_a()[0]));
                if (bufKey <= 0) continue;
                keys.add(bufKey);
                continue;
            }
            if (!(object instanceof List) || ((List)object).isEmpty() || (bufKey = MetaItem.get((ItemStack)((ItemStack)((List)object).get(0)))) <= 0) continue;
            keys.add(bufKey);
        }
        return keys;
    }

    public static TIntList getList(@Nonnull List<?> objects, @Nonnull ResourceHandler resourceHandler) {
        return Util.getList(objects.toArray(), resourceHandler);
    }

    public static TIntSet getSet(@Nonnull Collection<Resource> resourceCollection, int kind) {
        TIntHashSet keys = new TIntHashSet();
        resourceCollection.stream().filter(resource -> resource.childExists(kind)).forEach(arg_0 -> Util.lambda$getSet$1((TIntSet)keys, kind, arg_0));
        return keys;
    }

    public static List<ItemStack> stringListToItemStackList(@Nonnull List<String> stringList) {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        stringList.forEach(s -> {
            int separatorChar = s.indexOf(35);
            String itemName = s.substring(0, s.length());
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(separatorChar == -1 ? itemName : itemName.substring(0, separatorChar)));
            if (item != null) {
                int metadata = separatorChar == -1 ? 0 : Integer.parseInt(itemName.substring(separatorChar + 1, itemName.length()));
                itemStackList.add(new ItemStack(item, 1, metadata));
            }
        });
        return itemStackList;
    }

    private static /* synthetic */ void lambda$getSet$1(TIntSet keys, int kind, Resource resource) {
        keys.addAll((TIntCollection)MetaItem.getList(resource.getChild(kind).getEntries()));
    }
}

