/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.packets;

import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityEnchanter;
import io.netty.buffer.ByteBuf;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketIncrementEnchantLevel
implements IMessage {
    private BlockPos pos;
    private int enchantID;
    private boolean plus;

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public int getEnchantID() {
        return this.enchantID;
    }

    public void setEnchantID(int enchantID) {
        this.enchantID = enchantID;
    }

    public boolean isPlus() {
        return this.plus;
    }

    public void setPlus(boolean plus) {
        this.plus = plus;
    }

    public PacketIncrementEnchantLevel(BlockPos pos, int enchantID, boolean plus) {
        this.pos = pos;
        this.enchantID = enchantID;
        this.plus = plus;
    }

    public PacketIncrementEnchantLevel() {
    }

    public PacketIncrementEnchantLevel(TileEntityEnchanter enchanter, int enchantID, boolean plus) {
        this(enchanter.func_174877_v(), enchantID, plus);
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.pos = BlockPos.func_177969_a((long)byteBuf.readLong());
        this.enchantID = byteBuf.readInt();
        this.plus = byteBuf.readBoolean();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeLong(this.pos.func_177986_g());
        byteBuf.writeInt(this.enchantID);
        byteBuf.writeBoolean(this.plus);
    }

    public static class Handler
    implements IMessageHandler<PacketIncrementEnchantLevel, IMessage> {
        public IMessage onMessage(PacketIncrementEnchantLevel packetIncrementEnchantLevel, MessageContext messageContext) {
            FMLCommonHandler.instance().getWorldThread(messageContext.netHandler).func_152344_a(() -> this.handle(packetIncrementEnchantLevel, messageContext));
            return null;
        }

        private void handle(PacketIncrementEnchantLevel packetIncrementEnchantLevel, MessageContext ctx) {
            TileEntityEnchanter enchanter;
            int index;
            TileEntity te;
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            World world = playerEntity.func_130014_f_();
            if (world.func_175667_e(packetIncrementEnchantLevel.getPos()) && (te = world.func_175625_s(packetIncrementEnchantLevel.getPos())) instanceof TileEntityEnchanter && (index = (enchanter = (TileEntityEnchanter)te).getEnchantments().indexOf(packetIncrementEnchantLevel.enchantID)) != -1) {
                Enchantment enchantment = Enchantment.func_185262_c((int)enchanter.getEnchantments().get(index));
                int currentLevel = enchanter.getLevels().get(index);
                if (packetIncrementEnchantLevel.plus) {
                    ++currentLevel;
                    currentLevel = Math.min(currentLevel, enchantment.func_77325_b());
                } else {
                    --currentLevel;
                    currentLevel = Math.max(currentLevel, enchantment.func_77319_d());
                }
                enchanter.getLevels().set(index, currentLevel);
                enchanter.sendUpdates();
            }
        }
    }
}

