/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.multiblocks;

import com.nekokittygames.thaumictinkerer.common.helper.Mat2f;
import com.nekokittygames.thaumictinkerer.common.helper.TTVec2f;
import com.nekokittygames.thaumictinkerer.common.multiblocks.Multiblock;
import com.nekokittygames.thaumictinkerer.common.multiblocks.MultiblockBlock;
import com.nekokittygames.thaumictinkerer.common.multiblocks.MultiblockBlockType;
import com.nekokittygames.thaumictinkerer.common.multiblocks.MultiblockLayer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class MultiblockManager {
    private static Map<ResourceLocation, Multiblock> multiblocks = new HashMap<ResourceLocation, Multiblock>();
    public static Map<EnumFacing, Mat2f> FACING_ROTATIONS = new HashMap<EnumFacing, Mat2f>();

    public static void initMultiblocks() throws URISyntaxException, IOException {
        Path myPath;
        URI uri = MultiblockManager.class.getResource("/assets/thaumictinkerer/multiblocks").toURI();
        if (uri.getScheme().equals("jar")) {
            FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            myPath = fileSystem.getPath("/assets/thaumictinkerer/multiblocks", new String[0]);
        } else {
            myPath = Paths.get(uri);
        }
        Stream<Path> walk = Files.walk(myPath, new FileVisitOption[0]);
        walk.forEach(path -> {
            if (path.toString().endsWith("json")) {
                Multiblock multiblock = null;
                try {
                    multiblock = new Multiblock((Path)path);
                    multiblocks.put(multiblock.getId(), multiblock);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        FACING_ROTATIONS.put(EnumFacing.NORTH, new Mat2f().setIdentity());
        Mat2f tmp = new Mat2f();
        tmp.m00 = 0.0f;
        tmp.m01 = 1.0f;
        tmp.m10 = -1.0f;
        tmp.m11 = 0.0f;
        FACING_ROTATIONS.put(EnumFacing.EAST, tmp);
        tmp = new Mat2f();
        tmp.m00 = -1.0f;
        tmp.m01 = 0.0f;
        tmp.m10 = 0.0f;
        tmp.m11 = -1.0f;
        FACING_ROTATIONS.put(EnumFacing.SOUTH, tmp);
        tmp = new Mat2f();
        tmp.m00 = 0.0f;
        tmp.m01 = -1.0f;
        tmp.m10 = 1.0f;
        tmp.m11 = 0.0f;
        FACING_ROTATIONS.put(EnumFacing.WEST, tmp);
    }

    public static boolean checkMultiblock(World world, BlockPos keyBlock, ResourceLocation multiblock) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!MultiblockManager.checkMultiblock(world, keyBlock, multiblock, facing)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkMultiblockCombined(World world, BlockPos keyBlock, ResourceLocation multiblock) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!MultiblockManager.checkOutputMultiblock(world, keyBlock, multiblock, facing)) continue;
            return true;
        }
        return false;
    }

    public static EnumFacing checkMultiblockFacing(World world, BlockPos keyBlock, ResourceLocation multiblock) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!MultiblockManager.checkMultiblock(world, keyBlock, multiblock, facing)) continue;
            return facing;
        }
        return EnumFacing.UP;
    }

    public static boolean checkOutputMultiblock(World world, BlockPos keyBlock, ResourceLocation multiblockLocation, EnumFacing facing) {
        Multiblock multiblock = MultiblockManager.getMultiblock(multiblockLocation);
        if (multiblock == null) {
            return false;
        }
        Mat2f matrix = FACING_ROTATIONS.get(facing);
        boolean complete = true;
        Iterator<MultiblockLayer> it = multiblock.combinedIterator();
        while (it.hasNext()) {
            MultiblockLayer layer = it.next();
            for (MultiblockBlock block : layer) {
                TTVec2f tmpPos = new TTVec2f(block.getxOffset(), block.getzOffset());
                tmpPos = MultiblockManager.mul(matrix, tmpPos);
                BlockPos posToCheck = keyBlock.func_177971_a((Vec3i)new BlockPos((double)tmpPos.x, (double)layer.getyLevel(), (double)tmpPos.y));
                String blockType = block.getBlockName();
                MultiblockBlockType mBlockType = multiblock.getBlocks().get(blockType);
                boolean blockFound = false;
                if (blockType.equalsIgnoreCase("minecraft:air")) {
                    blockFound = world.func_175623_d(posToCheck);
                } else {
                    for (IBlockState blockState : mBlockType.getBlockTypes()) {
                        if (block.getExtraMeta() != -1) {
                            blockState = blockState.func_177230_c().func_176203_a(block.getExtraMeta());
                        }
                        if (blockState != world.func_180495_p(posToCheck)) continue;
                        blockFound = true;
                    }
                }
                if (blockFound) continue;
                return false;
            }
        }
        return true;
    }

    public static void outputMultiblock(World world, BlockPos keyBlock, ResourceLocation multiblockLocation, EnumFacing facing) throws Exception {
        Multiblock multiblock = MultiblockManager.getMultiblock(multiblockLocation);
        if (multiblock == null) {
            return;
        }
        Mat2f matrix = FACING_ROTATIONS.get(facing);
        boolean complete = true;
        Iterator<MultiblockLayer> it = multiblock.outputIterator();
        while (it.hasNext()) {
            MultiblockLayer layer = it.next();
            if (layer == null) continue;
            for (MultiblockBlock block : layer) {
                TTVec2f tmpPos = new TTVec2f(block.getxOffset(), block.getzOffset());
                tmpPos = MultiblockManager.mul(matrix, tmpPos);
                BlockPos posToCheck = keyBlock.func_177971_a((Vec3i)new BlockPos((double)tmpPos.x, (double)layer.getyLevel(), (double)tmpPos.y));
                String blockType = block.getBlockName();
                if (blockType.equalsIgnoreCase("minecraft:air")) {
                    world.func_175698_g(posToCheck);
                    continue;
                }
                MultiblockBlockType mBlockType = multiblock.getBlocks().get(blockType);
                boolean blockFound = false;
                if (mBlockType.getBlockTypes().size() < 1) {
                    throw new Exception("Invalid Output");
                }
                IBlockState state = mBlockType.getBlockTypes().get(0);
                if (block.getExtraMeta() != -1) {
                    state = state.func_177230_c().func_176203_a(block.getExtraMeta());
                }
                world.func_180501_a(posToCheck, state, 3);
            }
        }
    }

    public static boolean checkMultiblock(World world, BlockPos keyBlock, ResourceLocation multiblockLocation, EnumFacing facing) {
        Multiblock multiblock = MultiblockManager.getMultiblock(multiblockLocation);
        if (multiblock == null) {
            return false;
        }
        Mat2f matrix = FACING_ROTATIONS.get(facing);
        boolean complete = true;
        for (MultiblockLayer layer : multiblock) {
            for (MultiblockBlock block : layer) {
                TTVec2f tmpPos = new TTVec2f(block.getxOffset(), block.getzOffset());
                tmpPos = MultiblockManager.mul(matrix, tmpPos);
                BlockPos posToCheck = keyBlock.func_177971_a((Vec3i)new BlockPos((double)tmpPos.x, (double)layer.getyLevel(), (double)tmpPos.y));
                String blockType = block.getBlockName();
                MultiblockBlockType mBlockType = multiblock.getBlocks().get(blockType);
                boolean blockFound = false;
                if (blockType.equalsIgnoreCase("minecraft:air")) {
                    blockFound = world.func_175623_d(posToCheck);
                } else {
                    for (IBlockState blockState : mBlockType.getBlockTypes()) {
                        if (block.getExtraMeta() != -1) {
                            blockState = blockState.func_177230_c().func_176203_a(block.getExtraMeta());
                        }
                        if (blockState != world.func_180495_p(posToCheck)) continue;
                        blockFound = true;
                    }
                }
                if (blockFound) continue;
                return false;
            }
        }
        return true;
    }

    public static TTVec2f mul(Mat2f matrix, TTVec2f vec) {
        TTVec2f rotatedPos = new TTVec2f(matrix.m00 * vec.x + matrix.m01 * vec.y, matrix.m10 * vec.x + matrix.m11 * vec.y);
        return rotatedPos;
    }

    public static Multiblock getMultiblock(ResourceLocation location) {
        if (multiblocks.containsKey(location)) {
            return multiblocks.get(location);
        }
        return null;
    }

    public static Multiblock getMultiblock(IBlockState blockstate) {
        for (Multiblock block : multiblocks.values()) {
            if (block.getKeyBlock() != blockstate) continue;
            return block;
        }
        return null;
    }

    public static void clearMultiblocks() {
        multiblocks.clear();
    }
}

