/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.data.PlaneShape;
import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.world.generator.WorldGen;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class WorldGenSpout
extends WorldGen {
    private final List<WeightedBlock> cluster;
    private final WeightedBlock[] genBlock;
    private final INumberProvider radius;
    private final INumberProvider height;
    private PlaneShape shape = PlaneShape.CIRCLE;

    public WorldGenSpout(List<WeightedBlock> resource, List<WeightedBlock> material, INumberProvider radius, INumberProvider height) {
        this.cluster = resource;
        this.radius = radius;
        this.height = height;
        this.genBlock = material.toArray(new WeightedBlock[material.size()]);
    }

    public WorldGenSpout setShape(PlaneShape shape) {
        this.shape = shape;
        return this;
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int xCenter = pos.func_177958_n();
        int yCenter = pos.func_177956_o();
        int zCenter = pos.func_177952_p();
        INumberProvider.DataHolder data = new INumberProvider.DataHolder(pos);
        int height = this.height.intValue(world, rand, data);
        boolean r = false;
        for (int y = 0; y < height; ++y) {
            int radius = this.radius.intValue(world, rand, data.setPosition((Vec3i)pos.func_177982_a(0, y, 0)));
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (!this.shape.inArea(x, z, radius)) continue;
                    r |= WorldGenSpout.generateBlock(world, rand, xCenter + x, yCenter + y, zCenter + z, this.genBlock, this.cluster);
                }
            }
        }
        return r;
    }
}

