/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.variables;

import cofh.cofhworld.CoFHWorld;
import cofh.cofhworld.util.random.WeightedEnum;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigList;
import cofh.shade.com.typesafe.config.ConfigObject;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import java.util.List;

public class EnumData {
    public static <T extends Enum<T>> boolean parseEnumList(ConfigValue enumEntry, List<WeightedEnum<T>> list, Class<T> values) {
        if (enumEntry.valueType() == ConfigValueType.LIST) {
            ConfigList configList = (ConfigList)enumEntry;
            int e = configList.size();
            for (int i = 0; i < e; ++i) {
                WeightedEnum<T> entry = EnumData.parseEnumEntry((ConfigValue)configList.get(i), values);
                if (entry == null) {
                    return false;
                }
                list.add(entry);
            }
        } else {
            WeightedEnum<T> entry = EnumData.parseEnumEntry(enumEntry, values);
            if (entry == null) {
                return false;
            }
            list.add(entry);
        }
        return true;
    }

    public static <T extends Enum<T>> WeightedEnum<T> parseEnumEntry(ConfigValue enumEntry, Class<T> values) {
        int weight = 100;
        String type = null;
        switch (enumEntry.valueType()) {
            case LIST: {
                CoFHWorld.log.warn("Lists are not supported for enum values at line {}.", (Object)enumEntry.origin().lineNumber());
                return null;
            }
            case NULL: {
                CoFHWorld.log.warn("Null enum entry at line {}", (Object)enumEntry.origin().lineNumber());
                return null;
            }
            case OBJECT: {
                Config enumObject = ((ConfigObject)enumEntry).toConfig();
                if (enumObject.hasPath("name")) {
                    type = enumObject.getString("name");
                } else {
                    CoFHWorld.log.warn("Value missing 'name' field at line {}", (Object)enumEntry.origin().lineNumber());
                }
                if (!enumObject.hasPath("weight")) break;
                weight = enumObject.getInt("weight");
                break;
            }
            case STRING: {
                type = String.valueOf(enumEntry.unwrapped());
                break;
            }
            default: {
                CoFHWorld.log.warn("Invalid type for enum at line {}", (Object)enumEntry.origin().lineNumber());
                return null;
            }
        }
        try {
            T v = Enum.valueOf(values, type);
            return new WeightedEnum<T>(v, weight);
        }
        catch (IllegalArgumentException e) {
            CoFHWorld.log.error("Invalid enum entry {} on line {}", (Object)type, (Object)enumEntry.origin().lineNumber());
            return null;
        }
    }
}

