/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.data.numbers.random;

import cofh.cofhworld.data.numbers.ConstantProvider;
import cofh.cofhworld.data.numbers.INumberProvider;
import java.util.Random;
import net.minecraft.world.World;

public class SkellamRandomProvider
implements INumberProvider {
    protected INumberProvider min;

    public SkellamRandomProvider(Number value) {
        this.min = new ConstantProvider(value);
    }

    public SkellamRandomProvider(INumberProvider value) {
        this.min = value;
    }

    @Override
    public long longValue(World world, Random rand, INumberProvider.DataHolder data) {
        long val = this.min.longValue(world, rand, data);
        return SkellamRandomProvider.getRandomLong(val, rand) - SkellamRandomProvider.getRandomLong(val, rand);
    }

    @Override
    public double doubleValue(World world, Random rand, INumberProvider.DataHolder data) {
        double val = this.min.doubleValue(world, rand, data);
        return SkellamRandomProvider.getRandomDouble(val, rand) - SkellamRandomProvider.getRandomDouble(val, rand);
    }

    public static long getRandomLong(long val, Random rand) {
        long r;
        if (val == 0L) {
            return 0L;
        }
        int low = (int)(val & Integer.MAX_VALUE);
        int mid = (int)(val >>> 31 & Integer.MAX_VALUE);
        int high = (int)(val >>> 62 & Integer.MAX_VALUE);
        boolean mh = (mid | high) > 0;
        long l = r = mh ? (long)(rand.nextInt() & Integer.MAX_VALUE) : (long)rand.nextInt(low);
        if (mh) {
            r |= (long)(high > 0 ? rand.nextInt() & Integer.MAX_VALUE : rand.nextInt(mid)) << 31;
        }
        if (high > 0) {
            r |= (long)rand.nextInt(high) << 62;
        }
        return r;
    }

    public static double getRandomDouble(double val, Random rand) {
        return rand.nextDouble() * val;
    }
}

