/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.tile;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IContainerProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.api.tile.IUpgrade;
import reborncore.api.tile.IUpgradeable;
import reborncore.client.gui.slots.BaseSlot;
import reborncore.common.RebornCoreConfig;
import reborncore.common.blocks.RebornMachineBlock;
import reborncore.common.container.RebornContainer;
import reborncore.common.fluids.RebornFluidHandler;
import reborncore.common.fluids.RebornFluidTank;
import reborncore.common.network.NetworkManager;
import reborncore.common.network.packet.CustomDescriptionPacket;
import reborncore.common.recipes.IUpgradeHandler;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.tile.FluidConfiguration;
import reborncore.common.tile.SlotConfiguration;
import reborncore.common.util.Inventory;
import reborncore.common.util.Utils;

public class RebornMachineTile
extends TileEntity
implements ITickable,
ISidedInventory,
IUpgradeable,
IUpgradeHandler {
    public Inventory upgradeInventory = new Inventory(this.getUpgradeSlotCount(), "upgrades", 1, this);
    public SlotConfiguration slotConfiguration;
    public FluidConfiguration fluidConfiguration;
    double speedMultiplier = 0.0;
    double powerMultiplier = 1.0;
    protected Set<EnumFacing> supportedFacings = Utils.HORIZONTAL_FACINGS;
    protected byte facing = 0;
    protected boolean active = false;

    public void syncWithAll() {
        if (!this.field_145850_b.field_72995_K) {
            NetworkManager.sendToAllAround(new CustomDescriptionPacket(this.field_174879_c, this.func_189515_b(new NBTTagCompound())), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
        }
    }

    public void resetUpgrades() {
        this.resetPowerMulti();
        this.resetSpeedMulti();
    }

    public int getFacingInt() {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block instanceof RebornMachineBlock) {
            return ((RebornMachineBlock)block).getFacing(this.field_145850_b, this.field_174879_c).func_176745_a();
        }
        return 0;
    }

    public EnumFacing getFacingEnum() {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block instanceof RebornMachineBlock) {
            return ((RebornMachineBlock)block).getFacing(this.field_145850_b, this.field_174879_c);
        }
        return null;
    }

    public Optional<Inventory> getInventoryForTile() {
        if (this instanceof IInventoryProvider) {
            IInventoryProvider inventory = (IInventoryProvider)((Object)this);
            if (inventory.getInventory() == null) {
                return Optional.empty();
            }
            return Optional.of((Inventory)inventory.getInventory());
        }
        return Optional.empty();
    }

    protected Optional<RecipeCrafter> getCrafterForTile() {
        if (this instanceof IRecipeCrafterProvider) {
            IRecipeCrafterProvider crafterProvider = (IRecipeCrafterProvider)((Object)this);
            if (crafterProvider.getRecipeCrafter() == null) {
                return Optional.empty();
            }
            return Optional.of(crafterProvider.getRecipeCrafter());
        }
        return Optional.empty();
    }

    protected Optional<RebornContainer> getContainerForTile() {
        if (this instanceof IContainerProvider) {
            IContainerProvider containerProvider = (IContainerProvider)((Object)this);
            if (containerProvider.getContainer() == null) {
                return Optional.empty();
            }
            return Optional.of(containerProvider.getContainer());
        }
        return Optional.empty();
    }

    public boolean hasSlotConfig() {
        return true;
    }

    @Nullable
    public RebornFluidTank getTank() {
        return null;
    }

    public boolean showTankConfig() {
        return this.getTank() != null;
    }

    public int slotTransferSpeed() {
        return 4;
    }

    public int fluidTransferAmount() {
        return 250;
    }

    public void onPlaced(EntityLivingBase placer, ItemStack stack) {
        EnumFacing newFacing = this.getFacingForPlacement(placer);
        if (newFacing != this.getFacing()) {
            this.setFacing(newFacing);
        }
    }

    public EnumFacing getFacing() {
        return EnumFacing.values()[this.facing];
    }

    public boolean canSetFacing(EnumFacing facing) {
        return facing != this.getFacing() && this.supportedFacings.contains(facing);
    }

    public boolean setFacing(EnumFacing facing) {
        if (!this.canSetFacing(facing)) {
            return false;
        }
        this.facing = (byte)facing.ordinal();
        this.syncWithAll();
        this.notifyBlockUpdate();
        return true;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        this.syncWithAll();
        this.notifyBlockUpdate();
    }

    public IBlockState getBlockState() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().func_176223_P();
        if (blockState.func_177228_b().containsKey((Object)RebornMachineBlock.field_185512_D)) {
            blockState = blockState.func_177226_a((IProperty)RebornMachineBlock.field_185512_D, (Comparable)this.getFacing());
        }
        if (blockState.func_177228_b().containsKey(RebornMachineBlock.activeProperty)) {
            blockState = blockState.func_177226_a(RebornMachineBlock.activeProperty, (Comparable)Boolean.valueOf(this.isActive()));
        }
        return blockState;
    }

    protected void notifyBlockUpdate() {
        IBlockState state = this.getBlockState();
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 2);
    }

    protected EnumFacing getFacingForPlacement(EntityLivingBase placer) {
        if (this.supportedFacings.isEmpty()) {
            return EnumFacing.DOWN;
        }
        if (placer == null) {
            return EnumFacing.DOWN;
        }
        EnumFacing bestFacing = null;
        double bestScore = Double.NEGATIVE_INFINITY;
        Vec3d dir = placer.func_70040_Z();
        for (EnumFacing entry : this.supportedFacings) {
            double score = dir.func_72430_b(new Vec3d(entry.func_176734_d().func_176730_m()));
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestFacing = entry;
        }
        return bestFacing;
    }

    public void onLoad() {
        super.onLoad();
        if (this.slotConfiguration == null) {
            this.slotConfiguration = this.getInventoryForTile().isPresent() ? new SlotConfiguration(this.getInventoryForTile().get()) : new SlotConfiguration();
        }
        if (this.getTank() != null && this.fluidConfiguration == null) {
            this.fluidConfiguration = new FluidConfiguration();
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189515_b(new NBTTagCompound());
        this.func_189515_b(compound);
        return compound;
    }

    public void onDataPacket(net.minecraft.network.NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        if (this.field_145850_b.field_72995_K) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_189667_a(Rotation rotationIn) {
        this.setFacing(rotationIn.func_185831_a(this.getFacing()));
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (!this.supportedFacings.isEmpty()) {
            byte facingValue = tagCompound.func_74771_c("facing");
            this.facing = facingValue >= 0 && facingValue < EnumFacing.field_82609_l.length && this.supportedFacings.contains(EnumFacing.field_82609_l[facingValue]) ? facingValue : (!this.supportedFacings.isEmpty() ? (byte)this.supportedFacings.iterator().next().ordinal() : (byte)EnumFacing.DOWN.ordinal());
        }
        this.active = tagCompound.func_74767_n("active");
        if (this.getInventoryForTile().isPresent()) {
            this.getInventoryForTile().get().readFromNBT(tagCompound);
        }
        if (this.getCrafterForTile().isPresent()) {
            this.getCrafterForTile().get().readFromNBT(tagCompound);
        }
        this.slotConfiguration = tagCompound.func_74764_b("slotConfig") ? new SlotConfiguration(tagCompound.func_74775_l("slotConfig")) : (this.getInventoryForTile().isPresent() ? new SlotConfiguration(this.getInventoryForTile().get()) : new SlotConfiguration());
        if (tagCompound.func_74764_b("fluidConfig") && this.getTank() != null) {
            this.fluidConfiguration = new FluidConfiguration(tagCompound.func_74775_l("fluidConfig"));
        } else if (this.getTank() != null && this.fluidConfiguration == null) {
            this.fluidConfiguration = new FluidConfiguration();
        }
        this.upgradeInventory.readFromNBT(tagCompound, "Upgrades");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (!this.supportedFacings.isEmpty()) {
            tagCompound.func_74774_a("facing", this.facing);
        }
        tagCompound.func_74757_a("active", this.active);
        if (this.getInventoryForTile().isPresent()) {
            this.getInventoryForTile().get().writeToNBT(tagCompound);
        }
        if (this.getCrafterForTile().isPresent()) {
            this.getCrafterForTile().get().writeToNBT(tagCompound);
        }
        if (this.slotConfiguration != null) {
            tagCompound.func_74782_a("slotConfig", (NBTBase)this.slotConfiguration.serializeNBT());
        }
        if (this.fluidConfiguration != null) {
            tagCompound.func_74782_a("fluidConfig", (NBTBase)this.fluidConfiguration.serializeNBT());
        }
        this.upgradeInventory.writeToNBT(tagCompound, "Upgrades");
        return tagCompound;
    }

    public ITextComponent func_145748_c_() {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_145748_c_();
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (this.getTank() != null && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.fluidConfiguration != null && this.fluidConfiguration.getSideDetail(facing) != null) {
                FluidConfiguration.FluidConfig fluidConfig = this.fluidConfiguration.getSideDetail(facing);
                return fluidConfig.getIoConfig().isEnabled();
            }
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new SidedInvWrapper((ISidedInventory)this, facing));
        }
        if (this.getTank() != null && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new RebornFluidHandler(this, facing));
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        RecipeCrafter crafter = null;
        if (this.getCrafterForTile().isPresent()) {
            crafter = this.getCrafterForTile().get();
        }
        if (this.canBeUpgraded()) {
            this.resetUpgrades();
            for (int i = 0; i < this.getUpgradeSlotCount(); ++i) {
                ItemStack stack = this.getUpgradeInventory().func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IUpgrade)) continue;
                ((IUpgrade)stack.func_77973_b()).process(this, stack);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (crafter != null) {
                crafter.updateEntity();
            }
            if (this.slotConfiguration != null) {
                this.slotConfiguration.update(this);
            }
            if (this.fluidConfiguration != null) {
                this.fluidConfiguration.update(this);
            }
        }
    }

    public int func_70302_i_() {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_70302_i_();
        }
        return 0;
    }

    public boolean func_191420_l() {
        if (!this.getInventoryForTile().isPresent()) {
            return true;
        }
        for (ItemStack itemstack : this.getInventoryForTile().get().contents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_70301_a(index);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_70298_a(index, count);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_70304_b(index);
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.getInventoryForTile().isPresent()) {
            this.getInventoryForTile().get().func_70299_a(index, stack);
        }
    }

    public int func_70297_j_() {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_70297_j_();
        }
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.getInventoryForTile().isPresent()) {
            this.getInventoryForTile().get().func_174889_b(player);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (this.getInventoryForTile().isPresent()) {
            this.getInventoryForTile().get().func_174886_c(player);
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        RecipeCrafter crafter;
        if (this.slotConfiguration == null) {
            return false;
        }
        SlotConfiguration.SlotConfigHolder slotConfigHolder = this.slotConfiguration.getSlotDetails(index);
        if (slotConfigHolder.filter() && this.getCrafterForTile().isPresent() && !(crafter = this.getCrafterForTile().get()).isStackValidInput(stack)) {
            return false;
        }
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_94041_b(index, stack);
        }
        return false;
    }

    public int func_174887_a_(int id) {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_174887_a_(id);
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (this.getInventoryForTile().isPresent()) {
            this.getInventoryForTile().get().func_174885_b(id, value);
        }
    }

    public int func_174890_g() {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_174890_g();
        }
        return 0;
    }

    public void func_174888_l() {
        if (this.getInventoryForTile().isPresent()) {
            this.getInventoryForTile().get().func_174888_l();
        }
    }

    public String func_70005_c_() {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_70005_c_();
        }
        return null;
    }

    public boolean func_145818_k_() {
        if (this.getInventoryForTile().isPresent()) {
            return this.getInventoryForTile().get().func_145818_k_();
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (this.slotConfiguration == null) {
            return new int[0];
        }
        return this.slotConfiguration.getSlotsForSide(side).stream().filter(Objects::nonNull).filter(slotConfig -> slotConfig.slotIO.ioConfig != SlotConfiguration.ExtractConfig.NONE).mapToInt(value -> value.slotID).toArray();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        SlotConfiguration.SlotConfigHolder slotConfigHolder = this.slotConfiguration.getSlotDetails(index);
        SlotConfiguration.SlotConfig slotConfig = slotConfigHolder.getSideDetail(direction);
        if (slotConfig.slotIO.ioConfig.isInsert()) {
            RecipeCrafter crafter;
            if (slotConfigHolder.filter() && this.getCrafterForTile().isPresent() && !(crafter = this.getCrafterForTile().get()).isStackValidInput(itemStackIn)) {
                return false;
            }
            if (this.getContainerForTile().isPresent()) {
                RebornContainer container = this.getContainerForTile().get();
                if (container.slotMap.containsKey(index)) {
                    Slot slot = container.slotMap.get(index);
                    return slot.func_75214_a(itemStackIn);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        SlotConfiguration.SlotConfigHolder slotConfigHolder = this.slotConfiguration.getSlotDetails(index);
        SlotConfiguration.SlotConfig slotConfig = slotConfigHolder.getSideDetail(direction);
        if (slotConfig.slotIO.ioConfig.isExtact()) {
            if (this.getContainerForTile().isPresent()) {
                RebornContainer container = this.getContainerForTile().get();
                if (container.slotMap.containsKey(index)) {
                    BaseSlot slot = container.slotMap.get(index);
                    return slot.canWorldBlockRemove();
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public ISidedInventory getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public int getUpgradeSlotCount() {
        return 4;
    }

    @Override
    public void resetSpeedMulti() {
        this.speedMultiplier = 0.0;
    }

    @Override
    public double getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    @Override
    public void addPowerMulti(double amount) {
        this.powerMultiplier *= 1.0 + amount;
    }

    @Override
    public void resetPowerMulti() {
        this.powerMultiplier = 1.0;
    }

    @Override
    public double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    @Override
    public double getEuPerTick(double baseEu) {
        return baseEu * this.powerMultiplier;
    }

    @Override
    public void addSpeedMulti(double amount) {
        if (RebornCoreConfig.exponentialMachineSpeedScaling) {
            double percentSpeedToApply = 1.0 - amount;
            double percentSpeedCurrent = 1.0 - this.speedMultiplier;
            double newPercentSpeed = percentSpeedToApply * percentSpeedCurrent;
            this.speedMultiplier = 1.0 - newPercentSpeed;
        } else {
            this.speedMultiplier = this.speedMultiplier + amount <= 0.99 ? (this.speedMultiplier += amount) : 0.99;
        }
    }
}

