/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.blocks;

import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import reborncore.api.ToolManager;
import reborncore.api.tile.IMachineGuiHandler;
import reborncore.api.tile.IUpgrade;
import reborncore.api.tile.IUpgradeable;
import reborncore.api.tile.IWrenchable;
import reborncore.common.RebornCoreConfig;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.fluids.RebornFluidTank;
import reborncore.common.items.WrenchHelper;
import reborncore.common.tile.RebornMachineTile;
import reborncore.common.util.InventoryHelper;
import reborncore.common.util.Utils;

public abstract class RebornMachineBlock
extends BlockHorizontal
implements ITileEntityProvider,
IWrenchable {
    public static ItemStack basicFrameStack;
    public static ItemStack advancedFrameStack;
    boolean hasCustomStates;
    public static final IProperty<Boolean> activeProperty;

    public RebornMachineBlock() {
        this(false);
    }

    public RebornMachineBlock(boolean hasCustomStates) {
        this(hasCustomStates, Utils.HORIZONTAL_FACINGS);
    }

    public RebornMachineBlock(boolean hasCustomStates, Set<EnumFacing> supportedFacings) {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        if (!hasCustomStates) {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a(activeProperty, (Comparable)Boolean.valueOf(false)));
        }
        BlockWrenchEventHandler.wrenableBlocks.add((Block)this);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, activeProperty});
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        RebornMachineTile tile = RebornMachineBlock.getTileEntity((IBlockAccess)world, pos);
        if (tile == null) {
            return;
        }
        tile.onPlaced(placer, stack);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        InventoryHelper.dropInventoryItems(worldIn, pos);
        super.func_180663_b(worldIn, pos, state);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        RebornMachineTile tile = RebornMachineBlock.getTileEntity(world, pos);
        if (tile == null) {
            return state;
        }
        return tile.getBlockState();
    }

    public int func_176201_c(IBlockState state) {
        int facing = ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).ordinal();
        int active = (Boolean)state.func_177229_b(activeProperty) != false ? 1 : 0;
        return facing + active;
    }

    public IBlockState func_176203_a(int meta) {
        boolean active = false;
        if (meta >= field_185512_D.func_177700_c().size()) {
            active = true;
            meta -= field_185512_D.func_177700_c().size();
        }
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a(activeProperty, (Comparable)Boolean.valueOf(active));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return null;
    }

    @Override
    public EnumFacing getFacing(World world, BlockPos pos) {
        RebornMachineTile tile = RebornMachineBlock.getTileEntity((IBlockAccess)world, pos);
        if (tile == null) {
            return EnumFacing.DOWN;
        }
        return tile.getFacing();
    }

    @Override
    public boolean canSetFacing(World world, BlockPos pos, EnumFacing newFacing, EntityPlayer player) {
        RebornMachineTile tile = RebornMachineBlock.getTileEntity((IBlockAccess)world, pos);
        if (tile == null) {
            return false;
        }
        return tile.canSetFacing(newFacing);
    }

    @Override
    public boolean setFacing(World world, BlockPos pos, EnumFacing newFacing, EntityPlayer player) {
        RebornMachineTile tile = RebornMachineBlock.getTileEntity((IBlockAccess)world, pos);
        if (tile == null) {
            return false;
        }
        return tile.setFacing(newFacing);
    }

    public boolean isActive(World world, BlockPos pos) {
        RebornMachineTile tile = RebornMachineBlock.getTileEntity((IBlockAccess)world, pos);
        if (tile == null) {
            return false;
        }
        return tile.isActive();
    }

    public void setActive(boolean active, World world, BlockPos pos) {
        RebornMachineTile tile = RebornMachineBlock.getTileEntity((IBlockAccess)world, pos);
        if (tile == null) {
            return;
        }
        tile.setActive(active);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (RebornCoreConfig.wrenchRequired) {
            drops.add((Object)(this.isAdvanced() ? advancedFrameStack.func_77946_l() : basicFrameStack.func_77946_l()));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public boolean isAdvanced() {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        RebornFluidTank tank;
        ItemStack stack = playerIn.func_184586_b(hand);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        if (tileEntity instanceof RebornMachineTile && (tank = ((RebornMachineTile)tileEntity).getTank()) != null && FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)tank)) {
            return true;
        }
        if (!stack.func_190926_b()) {
            IUpgradeable upgradeableEntity;
            if (ToolManager.INSTANCE.canHandleTool(stack)) {
                if (WrenchHelper.handleWrench(stack, worldIn, pos, playerIn, side)) {
                    return true;
                }
            } else if (stack.func_77973_b() instanceof IUpgrade && tileEntity instanceof IUpgradeable && (upgradeableEntity = (IUpgradeable)tileEntity).canBeUpgraded() && InventoryHelper.testInventoryInsertion((IInventory)upgradeableEntity.getUpgradeInventory(), stack, null) > 0) {
                InventoryHelper.insertItemIntoInventory((IInventory)upgradeableEntity.getUpgradeInventory(), stack);
                playerIn.func_184611_a(EnumHand.MAIN_HAND, stack);
                return true;
            }
        }
        if (this.getGui() != null && !playerIn.func_70093_af()) {
            this.getGui().open(playerIn, pos, worldIn);
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public abstract IMachineGuiHandler getGui();

    protected static RebornMachineTile getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity instanceof RebornMachineTile ? (RebornMachineTile)tileEntity : null;
    }

    static {
        activeProperty = PropertyBool.func_177716_a((String)"active");
    }
}

